/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.codehaus.jettison.json.JSONObject;
import org.neo4j.function.Suppliers;
import org.neo4j.logging.AbstractPrintWriterLogger;
import org.neo4j.logging.FormattedLog;
import org.neo4j.logging.FormattedLoggerStandard;
import org.neo4j.logging.Level;
import org.neo4j.logging.Logger;

class FormattedLoggerJson
extends AbstractPrintWriterLogger {
    private final String category;
    private final Level level;
    private final String levelCategoryString;
    private final DateTimeFormatter dateTimeFormatter;
    private final FormattedLog formattedLog;
    private final Supplier<ZonedDateTime> supplier;

    FormattedLoggerJson(FormattedLog formattedLog, @Nonnull Supplier<PrintWriter> writerSupplier, @Nonnull Level level, String category, DateTimeFormatter dateTimeFormatter, Supplier<ZonedDateTime> zonedDateTimeSupplier) {
        super(writerSupplier, formattedLog.lock, formattedLog.autoFlush);
        FormattedLoggerJson.validateLevel(level);
        this.formattedLog = formattedLog;
        this.level = level;
        this.category = category;
        this.levelCategoryString = FormattedLoggerJson.createLevelCategoryString(level, category);
        this.dateTimeFormatter = dateTimeFormatter;
        this.supplier = zonedDateTimeSupplier;
    }

    private static String createLevelCategoryString(Level level, String category) {
        if (category != null && !category.isEmpty()) {
            return String.format("\"level\": \"%s\", \"category\": %s", level.name(), JSONObject.quote((String)category));
        }
        return String.format("\"level\": \"%s\"", level.name());
    }

    private static void validateLevel(Level level) {
        switch (level) {
            case DEBUG: 
            case INFO: 
            case WARN: 
            case ERROR: {
                return;
            }
        }
        throw new IllegalArgumentException("Cannot create JsonFormattedLogger with Level " + level);
    }

    @Override
    protected void writeLog(@Nonnull PrintWriter out, @Nonnull String message) {
        this.lineStart(out);
        out.write(JSONObject.quote((String)message));
        this.lineEnd(out);
        out.println();
    }

    @Override
    protected void writeLog(@Nonnull PrintWriter out, @Nonnull String message, @Nonnull Throwable throwable) {
        this.lineStart(out);
        out.write(JSONObject.quote((String)message));
        if (throwable.getMessage() != null) {
            out.write(", \"stacktraceMessage\": ");
            out.write(JSONObject.quote((String)throwable.getMessage()));
        }
        out.write(", \"stacktrace\": ");
        StringWriter sw = new StringWriter();
        PrintWriter stackTraceWriter = new PrintWriter(sw);
        throwable.printStackTrace(stackTraceWriter);
        out.write(JSONObject.quote((String)sw.toString()));
        this.lineEnd(out);
    }

    @Override
    protected Logger getBulkLogger(@Nonnull PrintWriter out, @Nonnull Object lock) {
        return new FormattedLoggerJson(this.formattedLog, Suppliers.singleton((Object)out), this.level, this.category, FormattedLoggerStandard.DATE_TIME_FORMATTER, () -> FormattedLoggerStandard.DEFAULT_CURRENT_DATE_TIME.apply(this.formattedLog.zoneId));
    }

    private void lineStart(PrintWriter out) {
        out.write("{\"time\": \"");
        out.write(this.time());
        out.write("\", ");
        out.write(this.levelCategoryString);
        out.write(", \"message\": ");
    }

    private void lineEnd(PrintWriter out) {
        out.write("}");
    }

    private String time() {
        return this.dateTimeFormatter.format(this.supplier.get());
    }
}

