/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.internal;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.neo4j.logging.AbstractLog;
import org.neo4j.logging.Log;
import org.neo4j.logging.Logger;
import org.neo4j.logging.NullLogger;
import org.neo4j.logging.internal.DatabaseLogContext;
import org.neo4j.logging.internal.DatabaseLogger;

public class DatabaseLog
extends AbstractLog {
    private final DatabaseLogContext logContext;
    private final Log delegate;
    private final Logger debugLogger;
    private final Logger infoLogger;
    private final Logger warnLogger;
    private final Logger errorLogger;

    DatabaseLog(DatabaseLogContext logContext, Log delegate) {
        this.logContext = logContext;
        this.delegate = delegate;
        this.debugLogger = new DatabaseLogger(logContext, delegate::debugLogger);
        this.infoLogger = new DatabaseLogger(logContext, delegate::infoLogger);
        this.warnLogger = new DatabaseLogger(logContext, delegate::warnLogger);
        this.errorLogger = new DatabaseLogger(logContext, delegate::errorLogger);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    @Override
    @Nonnull
    public Logger debugLogger() {
        return this.isDebugEnabled() ? this.debugLogger : NullLogger.getInstance();
    }

    @Override
    @Nonnull
    public Logger infoLogger() {
        return this.infoLogger;
    }

    @Override
    @Nonnull
    public Logger warnLogger() {
        return this.warnLogger;
    }

    @Override
    @Nonnull
    public Logger errorLogger() {
        return this.errorLogger;
    }

    @Override
    public void bulk(@Nonnull Consumer<Log> consumer) {
        this.delegate.bulk(log -> consumer.accept(new DatabaseLog(this.logContext, (Log)log)));
    }
}

