/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import java.util.List;
import org.neo4j.io.IOUtils;
import org.neo4j.logging.DuplicatingLog;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.log4j.LoggerTarget;
import org.neo4j.util.VisibleForTesting;

public class DuplicatingLogProvider
implements InternalLogProvider {
    private final InternalLogProvider logProvider1;
    private final InternalLogProvider logProvider2;

    public DuplicatingLogProvider(InternalLogProvider logProvider1, InternalLogProvider logProvider2) {
        this.logProvider1 = logProvider1;
        this.logProvider2 = logProvider2;
    }

    @Override
    public InternalLog getLog(Class<?> loggingClass) {
        return new DuplicatingLog((InternalLog)this.logProvider1.getLog((Class)loggingClass), (InternalLog)this.logProvider2.getLog((Class)loggingClass));
    }

    @Override
    public InternalLog getLog(String name) {
        return new DuplicatingLog(this.logProvider1.getLog(name), this.logProvider2.getLog(name));
    }

    @Override
    public InternalLog getLog(LoggerTarget target) {
        return new DuplicatingLog(this.logProvider1.getLog(target), this.logProvider2.getLog(target));
    }

    @Override
    public void close() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.logProvider1, this.logProvider2});
    }

    @VisibleForTesting
    public List<InternalLogProvider> getTargetLogProviders() {
        return List.of(this.logProvider1, this.logProvider2);
    }
}

