/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.lock;

import org.eclipse.collections.api.map.primitive.ImmutableIntObjectMap;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;

public enum ResourceType {
    NODE(0),
    RELATIONSHIP(1),
    INDEX_ENTRY(2),
    LABEL(3),
    RELATIONSHIP_TYPE(4),
    SCHEMA_NAME(5),
    RELATIONSHIP_DELETE(6),
    NODE_RELATIONSHIP_GROUP_DELETE(7),
    DEGREES(8),
    RELATIONSHIP_GROUP(9),
    PAGE(10);

    private static final ImmutableIntObjectMap<ResourceType> idToType;
    private final int typeId;

    private ResourceType(int typeId) {
        this.typeId = typeId;
    }

    public int typeId() {
        return this.typeId;
    }

    public static ResourceType fromId(int typeId) {
        return (ResourceType)((Object)idToType.get(typeId));
    }

    static {
        IntObjectHashMap mapping = new IntObjectHashMap();
        for (ResourceType type : ResourceType.values()) {
            mapping.put(type.typeId, (Object)type);
        }
        idToType = mapping.toImmutable();
    }
}

