/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.lock;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.neo4j.lock.Lock;
import org.neo4j.lock.LockService;
import org.neo4j.lock.LockType;
import org.neo4j.util.VisibleForTesting;

public class ReentrantLockService
implements LockService {
    private final ConcurrentMap<LockedEntity, LockInstance> locks = new ConcurrentHashMap<LockedEntity, LockInstance>();

    @VisibleForTesting
    int lockCount() {
        return this.locks.size();
    }

    @Override
    public Lock acquireNodeLock(long nodeId, LockType type) {
        return this.acquire(new LockedNode(nodeId), type);
    }

    @Override
    public Lock acquireRelationshipLock(long relationshipId, LockType type) {
        return this.acquire(new LockedRelationship(relationshipId), type);
    }

    @Override
    public Lock acquireCustomLock(int resourceType, long id, LockType type) {
        return this.acquire(new CustomLockedEntity(resourceType, id), type);
    }

    private Lock acquire(final LockedEntity key, LockType type) {
        final LockInstance lockInstance = this.lockInstance(key);
        final java.util.concurrent.locks.Lock variant = lockInstance.acquire(type);
        return new Lock(){
            private boolean released;

            @Override
            public void release() {
                if (!this.released) {
                    variant.unlock();
                    if (lockInstance.deref()) {
                        ReentrantLockService.this.locks.remove(key);
                    }
                    this.released = true;
                }
            }

            public String toString() {
                StringBuilder repr = new StringBuilder("{").append(key.toString()).append(' ');
                if (this.released) {
                    repr.append("RELEASED");
                } else {
                    repr.append(lockInstance);
                }
                return repr.append('}').toString();
            }
        };
    }

    private LockInstance lockInstance(LockedEntity key) {
        LockInstance suggestion = new LockInstance();
        LockInstance lockInstance;
        while ((lockInstance = this.locks.putIfAbsent(key, suggestion)) != null) {
            if (lockInstance.ref()) {
                return lockInstance;
            }
            LockSupport.parkNanos(1000000L);
        }
        return suggestion;
    }

    private record LockedNode(long id) implements LockedEntity
    {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static interface LockedEntity {
    }

    private record LockedRelationship(long id) implements LockedEntity
    {
    }

    private record CustomLockedEntity(int type, long id) implements LockedEntity
    {
    }

    private record LockInstance(ReentrantReadWriteLock lock, AtomicInteger usage) {
        private static final int DEAD = -1;

        LockInstance() {
            this(new ReentrantReadWriteLock(true), new AtomicInteger(1));
        }

        boolean ref() {
            return this.usage.updateAndGet(operand -> operand == -1 ? -1 : operand + 1) != -1;
        }

        java.util.concurrent.locks.Lock acquire(LockType type) {
            java.util.concurrent.locks.Lock variant = switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case LockType.EXCLUSIVE -> this.lock.writeLock();
                case LockType.SHARED -> this.lock.readLock();
            };
            ((java.util.concurrent.locks.Lock)variant).lock();
            return variant;
        }

        boolean deref() {
            return this.usage.updateAndGet(operand -> {
                assert (operand > 0);
                int result = operand - 1;
                return result == 0 ? -1 : result;
            }) == -1;
        }

        @Override
        public String toString() {
            return this.lock.toString();
        }
    }
}

