/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.concurrent.TimeUnit;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.lock.ResourceType;

public class LockAcquisitionTimeoutException
extends TransactionTerminatedException {
    public LockAcquisitionTimeoutException(ResourceType resourceType, long resourceId, long timeoutNano) {
        super((Status)Status.Transaction.LockAcquisitionTimeout, String.format("Unable to acquire lock for resource: %s with id: %d within %d millis.", new Object[]{resourceType, resourceId, TimeUnit.NANOSECONDS.toMillis(timeoutNano)}));
    }

    public LockAcquisitionTimeoutException(ErrorGqlStatusObject gqlStatusObject, ResourceType resourceType, long resourceId, long timeoutNano) {
        super(gqlStatusObject, (Status)Status.Transaction.LockAcquisitionTimeout, String.format("Unable to acquire lock for resource: %s with id: %d within %d millis.", new Object[]{resourceType, resourceId, TimeUnit.NANOSECONDS.toMillis(timeoutNano)}));
    }

    public LockAcquisitionTimeoutException(Status status, String message) {
        super(status, message);
    }

    public LockAcquisitionTimeoutException(ErrorGqlStatusObject gqlStatusObject, Status status, String message) {
        super(gqlStatusObject, status, message);
    }
}

