/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive;

import java.util.Arrays;
import org.neo4j.collection.primitive.PrimitiveLongCollection;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongVisitor;

public class PrimitiveLongList
implements PrimitiveLongCollection {
    private static final int DEFAULT_SIZE = 8;
    private long[] elements;
    private int size;

    PrimitiveLongList() {
        this(8);
    }

    PrimitiveLongList(int size) {
        this.elements = new long[size];
    }

    public void add(long element) {
        if (this.elements.length == this.size) {
            this.ensureCapacity();
        }
        this.elements[this.size++] = element;
    }

    public long get(int position) {
        if (position >= this.size) {
            throw new IndexOutOfBoundsException("Requested element: " + position + ", list size: " + this.size);
        }
        return this.elements[position];
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.elements = PrimitiveLongCollections.EMPTY_LONG_ARRAY;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public PrimitiveLongIterator iterator() {
        return new PrimitiveLongListIterator();
    }

    @Override
    public <E extends Exception> void visitKeys(PrimitiveLongVisitor<E> visitor) throws E {
        throw new UnsupportedOperationException();
    }

    public long[] toArray() {
        return Arrays.copyOf(this.elements, this.size);
    }

    private void ensureCapacity() {
        int newCapacity;
        int currentCapacity = this.elements.length;
        int n = newCapacity = currentCapacity == 0 ? 8 : currentCapacity << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("Fail to increase list capacity.");
        }
        this.elements = Arrays.copyOf(this.elements, newCapacity);
    }

    private class PrimitiveLongListIterator
    extends PrimitiveLongCollections.PrimitiveLongBaseIterator {
        int cursor;

        private PrimitiveLongListIterator() {
        }

        @Override
        protected boolean fetchNext() {
            return this.cursor < PrimitiveLongList.this.size && this.next(PrimitiveLongList.this.elements[this.cursor++]);
        }
    }
}

