/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.time.Clock;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.DependencySatisfier;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.LocalConfig;
import org.neo4j.dbms.database.DatabasePageCache;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.index.internal.gbptree.GroupingRecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.id.DefaultIdController;
import org.neo4j.internal.id.DefaultIdGeneratorFactory;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.schema.IndexConfigCompleter;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.IOController;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCacheOpenOptions;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.OldestTransactionIdFactory;
import org.neo4j.io.pagecache.context.TransactionIdSnapshotFactory;
import org.neo4j.io.pagecache.context.VersionContextSupplier;
import org.neo4j.io.pagecache.impl.muninn.VersionStorage;
import org.neo4j.io.pagecache.prefetch.PagePrefetcher;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.BinarySupportedKernelVersions;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.KernelVersionRepository;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.availability.AvailabilityListener;
import org.neo4j.kernel.availability.CompositeDatabaseAvailabilityGuard;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.database.DefaultForceOperation;
import org.neo4j.kernel.database.MetadataCache;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.extension.DatabaseExtensions;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionFailureStrategies;
import org.neo4j.kernel.extension.context.DatabaseExtensionContext;
import org.neo4j.kernel.impl.api.DatabaseSchemaState;
import org.neo4j.kernel.impl.api.TransactionVisibilityProvider;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.context.TransactionVersionContextSupplier;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.index.DatabaseIndexStats;
import org.neo4j.kernel.impl.locking.LockManager;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.store.FileStoreProviderRegistry;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointerImpl;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.checkpoint.RecoveryThreshold;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.StoreCopyCheckPointMutex;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategyFactory;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruningImpl;
import org.neo4j.kernel.impl.transaction.state.StaticIndexProviderMap;
import org.neo4j.kernel.impl.transaction.state.StaticIndexProviderMapFactory;
import org.neo4j.kernel.impl.transaction.state.storeview.FullScanStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.IndexStoreViewFactory;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.kernel.recovery.CorruptedLogsTruncator;
import org.neo4j.kernel.recovery.DefaultRecoveryService;
import org.neo4j.kernel.recovery.LogTailExtractor;
import org.neo4j.kernel.recovery.RecoveryExtension;
import org.neo4j.kernel.recovery.RecoveryMode;
import org.neo4j.kernel.recovery.RecoveryMonitor;
import org.neo4j.kernel.recovery.RecoveryPredicate;
import org.neo4j.kernel.recovery.RecoveryRequiredChecker;
import org.neo4j.kernel.recovery.RecoveryStartInformationProvider;
import org.neo4j.kernel.recovery.RecoveryStartupChecker;
import org.neo4j.kernel.recovery.TransactionLogsRecovery;
import org.neo4j.kernel.recovery.facade.DatabaseRecoveryFacade;
import org.neo4j.lock.LockService;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.Level;
import org.neo4j.logging.LoggerPrintWriterAdaptor;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.HealthEventGenerator;
import org.neo4j.monitoring.Monitors;
import org.neo4j.monitoring.Panic;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.service.Services;
import org.neo4j.storageengine.api.ConstraintRuleAccessor;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.ReadableStorageEngine;
import org.neo4j.storageengine.api.RecoveryState;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StorageFilesState;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.time.Clocks;
import org.neo4j.time.Stopwatch;
import org.neo4j.token.CreatingTokenHolder;
import org.neo4j.token.ReadOnlyTokenCreator;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.values.DefaultElementIdMapperV1;
import org.neo4j.values.ElementIdMapper;

public final class Recovery {
    private Recovery() {
    }

    public static DatabaseRecoveryFacade recoveryFacade(FileSystemAbstraction fs, PageCache pageCache, Tracers tracers, Config config, MemoryTracker memoryTracker, InternalLogProvider logProvider, KernelVersionProvider emptyLogsFallbackKernelVersion, NamedDatabaseId databaseId) {
        return new DatabaseRecoveryFacade(fs, pageCache, new DatabaseTracers(tracers, databaseId), config, memoryTracker, logProvider, emptyLogsFallbackKernelVersion);
    }

    public static boolean isRecoveryRequired(FileSystemAbstraction fs, DatabaseLayout databaseLayout, Config config, MemoryTracker memoryTracker) throws Exception {
        Objects.requireNonNull(databaseLayout);
        Objects.requireNonNull(config);
        Objects.requireNonNull(fs);
        config = Config.newBuilder().fromConfig(config).set(GraphDatabaseSettings.pagecache_memory, (Object)ByteUnit.mebiBytes((long)8L)).build();
        try (JobScheduler jobScheduler = JobSchedulerFactory.createInitialisedScheduler();){
            boolean bl;
            block12: {
                PageCache pageCache = Recovery.getPageCache(config, fs, jobScheduler);
                try {
                    bl = Recovery.isRecoveryRequired(fs, pageCache, databaseLayout, config, Optional.empty(), memoryTracker, DatabaseTracers.EMPTY);
                    if (pageCache == null) break block12;
                }
                catch (Throwable throwable) {
                    if (pageCache != null) {
                        try {
                            pageCache.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pageCache.close();
            }
            return bl;
        }
    }

    public static boolean isRecoveryRequired(FileSystemAbstraction fs, PageCache pageCache, DatabaseLayout databaseLayout, Config config, Optional<LogTailMetadata> logTailMetadata, MemoryTracker memoryTracker, DatabaseTracers databaseTracers) throws IOException {
        return Recovery.isRecoveryRequired(fs, pageCache, databaseLayout, StorageEngineFactory.selectStorageEngine((FileSystemAbstraction)fs, (DatabaseLayout)databaseLayout, (Configuration)config), config, logTailMetadata, memoryTracker, databaseTracers);
    }

    public static boolean isRecoveryRequired(FileSystemAbstraction fs, PageCache pageCache, DatabaseLayout layout, StorageEngineFactory storageEngineFactory, Config config, Optional<LogTailMetadata> logTailMetadata, MemoryTracker memoryTracker, DatabaseTracers databaseTracers) throws IOException {
        RecoveryRequiredChecker requiredChecker = new RecoveryRequiredChecker(fs, pageCache, config, storageEngineFactory, databaseTracers);
        DatabaseLayout databaseLayout = storageEngineFactory.formatSpecificDatabaseLayout(layout);
        return logTailMetadata.isPresent() ? requiredChecker.isRecoveryRequiredAt(databaseLayout, logTailMetadata.get()) : requiredChecker.isRecoveryRequiredAt(databaseLayout, memoryTracker);
    }

    public static Context context(FileSystemAbstraction fs, PageCache pageCache, DatabaseTracers tracers, Config config, DatabaseLayout databaseLayout, MemoryTracker memoryTracker, IOController ioController, InternalLogProvider logProvider, KernelVersionProvider emptyLogsFallbackKernelVersion) {
        return new Context(fs, pageCache, databaseLayout, config, memoryTracker, tracers, ioController, logProvider, emptyLogsFallbackKernelVersion);
    }

    public static Context context(FileSystemAbstraction fs, PageCache pageCache, DatabaseTracers tracers, Config config, DatabaseLayout databaseLayout, MemoryTracker memoryTracker, IOController ioController, InternalLogProvider logProvider, LogTailMetadata logTail) {
        return new Context(fs, pageCache, databaseLayout, config, memoryTracker, tracers, ioController, logProvider, logTail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean performRecovery(Context context) throws IOException {
        Iterable<ExtensionFactory<?>> extensionFactories;
        Objects.requireNonNull(context);
        StorageEngineFactory storageEngineFactory = StorageEngineFactory.selectStorageEngine((FileSystemAbstraction)context.fs, (DatabaseLayout)context.databaseLayout, (Configuration)context.config);
        Iterable<ExtensionFactory<?>> iterable = extensionFactories = context.extensionFactories != null ? context.extensionFactories : Recovery.loadExtensions();
        assert (!(context.pageCache instanceof DatabasePageCache)) : "Recovery should use global page cache to avoid using overloaded mapping.";
        LocalConfig config = new LocalConfig(context.config);
        try {
            boolean bl = Recovery.performRecovery(context.fs, context.pageCache, context.tracers, (Config)config, storageEngineFactory.formatSpecificDatabaseLayout(context.databaseLayout), storageEngineFactory, context.forceRunRecovery, context.logProvider, context.globalMonitors, extensionFactories, context.providedLogTail, context.startupChecker, context.memoryTracker, context.clock, context.ioController, context.recoveryPredicate, context.rollbackIncompleteTransactions, context.awaitIndexesOnlineMillis, context.emptyLogsFallbackKernelVersion, context.mode);
            return bl;
        }
        finally {
            config.removeAllLocalListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean performRecovery(FileSystemAbstraction fs, PageCache pageCache, DatabaseTracers tracers, Config config, DatabaseLayout databaseLayout, StorageEngineFactory storageEngineFactory, boolean forceRunRecovery, InternalLogProvider logProvider, Monitors globalMonitors, Iterable<ExtensionFactory<?>> extensionFactories, Optional<LogTailMetadata> providedLogTail, RecoveryStartupChecker startupChecker, MemoryTracker memoryTracker, Clock clock, IOController ioController, RecoveryPredicate recoveryPredicate, boolean rollbackIncompleteTransactions, long awaitIndexesOnlineMillis, KernelVersionProvider emptyLogsFallbackKernelVersion, RecoveryMode mode) throws IOException {
        InternalLog recoveryLog = logProvider.getLog(Recovery.class);
        if (!forceRunRecovery && !Recovery.isRecoveryRequired(fs, pageCache, databaseLayout, storageEngineFactory, config, providedLogTail, memoryTracker, tracers)) {
            return false;
        }
        Recovery.checkAllFilesPresence(databaseLayout, fs, pageCache, storageEngineFactory);
        LifeSupport recoveryLife = new LifeSupport();
        NamedDatabaseId namedDatabaseId = Recovery.createRecoveryDatabaseId(fs, pageCache, databaseLayout, storageEngineFactory);
        Monitors monitors = new Monitors(globalMonitors, logProvider);
        VersionStorage recoveryVersionStorage = VersionStorage.EMPTY_STORAGE;
        DatabasePageCache databasePageCache = new DatabasePageCache(pageCache, ioController, recoveryVersionStorage, config);
        SimpleLogService logService = new SimpleLogService(logProvider);
        DatabaseReadOnlyChecker readOnlyChecker = DatabaseReadOnlyChecker.writable();
        DatabaseSchemaState schemaState = new DatabaseSchemaState(logProvider);
        JobScheduler scheduler = (JobScheduler)recoveryLife.add((Lifecycle)JobSchedulerFactory.createInitialisedScheduler());
        RecoveryAvailabilityGuard guard = new RecoveryAvailabilityGuard(namedDatabaseId, clock, recoveryLog);
        recoveryLife.add((Lifecycle)guard);
        TransactionVersionContextSupplier versionContextSupplier = new TransactionVersionContextSupplier();
        versionContextSupplier.init(TransactionIdSnapshotFactory.EMPTY_SNAPSHOT_FACTORY, OldestTransactionIdFactory.EMPTY_OLDEST_ID_FACTORY);
        CursorContextFactory cursorContextFactory = new CursorContextFactory(tracers.getPageCacheTracer(), (VersionContextSupplier)versionContextSupplier);
        DatabaseHealth databaseHealth = new DatabaseHealth(HealthEventGenerator.NO_OP, recoveryLog);
        TokenHolders tokenHolders = new TokenHolders((TokenHolder)new CreatingTokenHolder(ReadOnlyTokenCreator.READ_ONLY, "PropertyKey"), (TokenHolder)new CreatingTokenHolder(ReadOnlyTokenCreator.READ_ONLY, "Label"), (TokenHolder)new CreatingTokenHolder(ReadOnlyTokenCreator.READ_ONLY, "RelationshipType"));
        RecoveryCleanupWorkCollector recoveryCleanupCollector = (RecoveryCleanupWorkCollector)recoveryLife.add((Lifecycle)new GroupingRecoveryCleanupWorkCollector(scheduler, Group.INDEX_CLEANUP, Group.INDEX_CLEANUP_WORK, databaseLayout.getDatabaseName()));
        DatabaseExtensions extensions = (DatabaseExtensions)recoveryLife.add((Lifecycle)Recovery.instantiateRecoveryExtensions(databaseLayout, fs, config, (LogService)logService, databasePageCache, scheduler, DbmsInfo.TOOL, monitors, tokenHolders, recoveryCleanupCollector, readOnlyChecker, extensionFactories, guard, tracers, namedDatabaseId, cursorContextFactory, databaseHealth));
        Dependencies indexDependencies = new Dependencies((DependencyResolver)extensions);
        indexDependencies.satisfyDependencies(new Object[]{recoveryVersionStorage});
        StaticIndexProviderMap indexProviderMap = (StaticIndexProviderMap)recoveryLife.add((Lifecycle)StaticIndexProviderMapFactory.create(recoveryLife, config, databasePageCache, fs, (LogService)logService, monitors, readOnlyChecker, TopologyGraphDbmsModel.HostedOnMode.SINGLE, recoveryCleanupCollector, databaseLayout, tokenHolders, scheduler, cursorContextFactory, tracers.getPageCacheTracer(), (DependencyResolver)indexDependencies));
        LogTailMetadata logTailMetadata = providedLogTail.orElseGet(() -> Recovery.loadLogTail(fs, tracers, config, databaseLayout, storageEngineFactory, memoryTracker, emptyLogsFallbackKernelVersion));
        MetadataCache recoveryMetaDataCache = new MetadataCache(logTailMetadata);
        StorageEngine storageEngine = storageEngineFactory.instantiate(fs, clock, databaseLayout, config, (PageCache)databasePageCache, tokenHolders, (SchemaState)schemaState, (ConstraintRuleAccessor)ConstraintSemantics.getConstraintSemantics(), (IndexConfigCompleter)indexProviderMap, LockService.NO_LOCK_SERVICE, (IdGeneratorFactory)new DefaultIdGeneratorFactory(fs, recoveryCleanupCollector, tracers.getPageCacheTracer(), databaseLayout.getDatabaseName()), databaseHealth, logService.getInternalLogProvider(), logService.getUserLogProvider(), recoveryCleanupCollector, logTailMetadata, (KernelVersionRepository)recoveryMetaDataCache, memoryTracker, cursorContextFactory, tracers.getPageCacheTracer(), recoveryVersionStorage, PagePrefetcher.DISABLED);
        if (storageEngine.getOpenOptions().contains((Object)PageCacheOpenOptions.MULTI_VERSIONED)) {
            mode = RecoveryMode.FULL;
        } else {
            rollbackIncompleteTransactions = true;
        }
        FullScanStoreView fullScanStoreView = new FullScanStoreView(LockService.NO_LOCK_SERVICE, (ReadableStorageEngine)storageEngine, config, scheduler);
        IndexStoreViewFactory indexStoreViewFactory = new IndexStoreViewFactory(config, (ReadableStorageEngine)storageEngine, LockManager.NO_LOCKS_LOCK_MANAGER, fullScanStoreView, LockService.NO_LOCK_SERVICE, logProvider);
        IndexStatisticsStore indexStatisticsStore = new IndexStatisticsStore((PageCache)databasePageCache, fs, databaseLayout, recoveryCleanupCollector, false, cursorContextFactory, tracers.getPageCacheTracer(), storageEngine.getOpenOptions());
        IndexingService indexingService = Database.buildIndexingService(storageEngine, schemaState, indexStoreViewFactory, indexStatisticsStore, new DatabaseIndexStats(), config, scheduler, indexProviderMap, (TokenNameLookup)tokenHolders, (ElementIdMapper)new DefaultElementIdMapperV1(namedDatabaseId), logProvider, (IndexMonitor)monitors.newMonitor(IndexMonitor.class, new String[0]), cursorContextFactory, memoryTracker, databaseLayout.getDatabaseName(), readOnlyChecker, clock, (KernelVersionProvider)recoveryMetaDataCache, fs, TransactionVisibilityProvider.EMPTY_VISIBILITY_PROVIDER);
        MetadataProvider metadataProvider = storageEngine.metadataProvider();
        Dependencies dependencies = Dependencies.dependenciesOf((Object[])new Object[]{databaseLayout, config, databasePageCache, fs, logProvider, tokenHolders, schemaState, ConstraintSemantics.getConstraintSemantics(), LockService.NO_LOCK_SERVICE, databaseHealth, new DefaultIdGeneratorFactory(fs, recoveryCleanupCollector, tracers.getPageCacheTracer(), databaseLayout.getDatabaseName()), new DefaultIdController(), readOnlyChecker, cursorContextFactory, logService, metadataProvider});
        LogFiles logFiles = LogFilesBuilder.builder(databaseLayout, fs, (KernelVersionProvider)recoveryMetaDataCache).withStorageEngineFactory(storageEngineFactory).withConfig(config).withDatabaseTracers(tracers).withExternalLogTailMetadata(logTailMetadata).withDependencies((DependencyResolver)dependencies).withMemoryTracker(memoryTracker).build();
        boolean failOnCorruptedLogFiles = (Boolean)config.get(GraphDatabaseInternalSettings.fail_on_corrupted_log_files);
        Recovery.validateStoreId(logTailMetadata, storageEngine.retrieveStoreId());
        TransactionMetadataCache metadataCache = new TransactionMetadataCache();
        PhysicalLogicalTransactionStore transactionStore = new PhysicalLogicalTransactionStore(logFiles, metadataCache, storageEngineFactory.commandReaderFactory(), monitors, failOnCorruptedLogFiles, config);
        LifeSupport schemaLife = new LifeSupport();
        schemaLife.add(storageEngine.schemaAndTokensLifecycle());
        schemaLife.add((Lifecycle)indexingService);
        Boolean doParallelRecovery = (Boolean)config.get(GraphDatabaseInternalSettings.do_parallel_recovery);
        RecoveryMonitor recoveryMonitor = (RecoveryMonitor)monitors.newMonitor(RecoveryMonitor.class, new String[0]);
        TransactionLogsRecovery transactionLogsRecovery = Recovery.transactionLogRecovery(fs, (TransactionIdStore)metadataProvider, recoveryMonitor, (RecoveryStartInformationProvider.Monitor)monitors.newMonitor(RecoveryStartInformationProvider.Monitor.class, new String[0]), logFiles, storageEngine, (KernelVersionProvider)logTailMetadata, transactionStore, (LogVersionRepository)metadataProvider, (Lifecycle)schemaLife, databaseLayout, failOnCorruptedLogFiles, recoveryLog, startupChecker, memoryTracker, clock, doParallelRecovery, recoveryPredicate, rollbackIncompleteTransactions, cursorContextFactory, mode, new BinarySupportedKernelVersions(config));
        DefaultForceOperation forceOperation = new DefaultForceOperation(indexingService, storageEngine, databasePageCache);
        CheckpointAppender checkpointAppender = logFiles.getCheckpointFile().getCheckpointAppender();
        LogPruningImpl logPruning = new LogPruningImpl(fs, logFiles, logProvider, new LogPruneStrategyFactory(), clock, config, new ReentrantLock());
        CheckPointerImpl checkPointer = new CheckPointerImpl(metadataProvider, RecoveryThreshold.INSTANCE, forceOperation, logPruning, checkpointAppender, (Panic)databaseHealth, logProvider, tracers, new StoreCopyCheckPointMutex(), cursorContextFactory, clock, ioController, (KernelVersionProvider)recoveryMetaDataCache);
        recoveryLife.add((Lifecycle)indexStatisticsStore);
        recoveryLife.add((Lifecycle)storageEngine);
        recoveryLife.add((Lifecycle)new MissingTransactionLogsCheck(config, logTailMetadata, recoveryLog));
        recoveryLife.add((Lifecycle)logFiles);
        recoveryLife.add((Lifecycle)transactionLogsRecovery);
        recoveryLife.add((Lifecycle)checkPointer);
        try {
            recoveryLife.start();
            if (databaseHealth.hasNoPanic()) {
                if (awaitIndexesOnlineMillis > 0L) {
                    Recovery.awaitIndexesOnline(indexingService, awaitIndexesOnlineMillis);
                }
                extensions.stop();
                String recoveryMessage = logTailMetadata.logsMissing() ? "Recovery with missing logs completed." : "Recovery completed.";
                checkPointer.forceCheckPoint(new SimpleTriggerInfo(recoveryMessage));
            }
        }
        finally {
            recoveryLife.shutdown();
            recoveryMonitor.recoveryCompleted();
        }
        if (!databaseHealth.hasNoPanic()) {
            throw new IllegalStateException(databaseHealth.causeOfPanic());
        }
        return true;
    }

    private static void awaitIndexesOnline(IndexingService indexingService, long awaitIndexesOnlineMillis) {
        Stopwatch stopWatch = Stopwatch.start();
        try {
            for (IndexProxy indexProxy : indexingService.getIndexProxies()) {
                while (stopWatch.hasTimedOut(awaitIndexesOnlineMillis, TimeUnit.MILLISECONDS) && indexProxy.getState() == InternalIndexState.POPULATING) {
                    TimeUnit.MILLISECONDS.sleep(10L);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static LogTailMetadata loadLogTail(FileSystemAbstraction fs, DatabaseTracers tracers, Config config, DatabaseLayout databaseLayout, StorageEngineFactory storageEngineFactory, MemoryTracker memoryTracker, KernelVersionProvider emptyLogsFallbackKernelVersion) {
        try {
            return new LogTailExtractor(fs, config, storageEngineFactory, tracers, false).getTailMetadata(databaseLayout, memoryTracker, emptyLogsFallbackKernelVersion);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException("Fail to load log tail.", ioe);
        }
    }

    private static NamedDatabaseId createRecoveryDatabaseId(FileSystemAbstraction fs, PageCache pageCache, DatabaseLayout databaseLayout, StorageEngineFactory storageEngineFactory) {
        UUID uuid = storageEngineFactory.databaseIdUuid(fs, databaseLayout, pageCache, CursorContext.NULL_CONTEXT).orElse(new UUID(0L, 0L));
        return DatabaseIdFactory.from((String)databaseLayout.getDatabaseName(), (UUID)uuid);
    }

    public static void validateStoreId(LogTailMetadata tailMetadata, StoreId storeId) {
        StoreId txStoreId;
        Optional optionalTxStoreId = tailMetadata.getStoreId();
        if (optionalTxStoreId.isPresent() && !storeId.isSameOrUpgradeSuccessor(txStoreId = (StoreId)optionalTxStoreId.get()) && !txStoreId.isSameOrUpgradeSuccessor(storeId)) {
            throw new RuntimeException("Mismatching store id. Store StoreId: " + storeId + ". Transaction log StoreId: " + txStoreId);
        }
    }

    private static void checkAllFilesPresence(DatabaseLayout databaseLayout, FileSystemAbstraction fs, PageCache pageCache, StorageEngineFactory storageEngineFactory) {
        StorageFilesState state = storageEngineFactory.checkStoreFileState(fs, databaseLayout, pageCache);
        if (state.recoveryState() == RecoveryState.UNRECOVERABLE) {
            throw new RuntimeException(String.format("Store files %s is(are) missing and recovery is not possible. Please restore from a consistent backup.", state.missingFiles()));
        }
    }

    private static TransactionLogsRecovery transactionLogRecovery(FileSystemAbstraction fileSystemAbstraction, TransactionIdStore transactionIdStore, RecoveryMonitor recoveryMonitor, RecoveryStartInformationProvider.Monitor positionMonitor, LogFiles logFiles, StorageEngine storageEngine, KernelVersionProvider versionProvider, LogicalTransactionStore logicalTransactionStore, LogVersionRepository logVersionRepository, Lifecycle schemaLife, DatabaseLayout databaseLayout, boolean failOnCorruptedLogFiles, InternalLog log, RecoveryStartupChecker startupChecker, MemoryTracker memoryTracker, Clock clock, boolean doParallelRecovery, RecoveryPredicate recoveryPredicate, boolean rollbackIncompleteTransactions, CursorContextFactory contextFactory, RecoveryMode mode, BinarySupportedKernelVersions binarySupportedKernelVersions) {
        DefaultRecoveryService recoveryService = new DefaultRecoveryService(storageEngine, transactionIdStore, logicalTransactionStore, logVersionRepository, logFiles, versionProvider, positionMonitor, log, doParallelRecovery, contextFactory);
        CorruptedLogsTruncator logsTruncator = new CorruptedLogsTruncator(databaseLayout.databaseDirectory(), logFiles, fileSystemAbstraction, memoryTracker);
        LoggerPrintWriterAdaptor loggerPrintWriterAdaptor = new LoggerPrintWriterAdaptor(log, Level.INFO);
        return new TransactionLogsRecovery(logFiles, versionProvider, recoveryService, logsTruncator, schemaLife, recoveryMonitor, ProgressMonitorFactory.basicTextual((Writer)loggerPrintWriterAdaptor), failOnCorruptedLogFiles, startupChecker, recoveryPredicate, rollbackIncompleteTransactions, contextFactory, clock, binarySupportedKernelVersions, mode);
    }

    private static Iterable<ExtensionFactory<?>> loadExtensions() {
        return Iterables.cast((Iterable)Services.loadAll(ExtensionFactory.class));
    }

    private static DatabaseExtensions instantiateRecoveryExtensions(DatabaseLayout databaseLayout, FileSystemAbstraction fileSystem, Config config, LogService logService, PageCache pageCache, JobScheduler jobScheduler, DbmsInfo info, Monitors monitors, TokenHolders tokenHolders, RecoveryCleanupWorkCollector recoveryCleanupCollector, DatabaseReadOnlyChecker readOnlyChecker, Iterable<ExtensionFactory<?>> extensionFactories, AvailabilityGuard availabilityGuard, DatabaseTracers tracers, NamedDatabaseId namedDatabaseId, CursorContextFactory contextFactory, DatabaseHealth databaseHealth) {
        List<ExtensionFactory<?>> recoveryExtensions = Iterables.stream(extensionFactories).filter(extension -> extension.getClass().isAnnotationPresent(RecoveryExtension.class)).toList();
        NonListenableMonitors nonListenableMonitors = new NonListenableMonitors(monitors, logService.getInternalLogProvider());
        Dependencies deps = Dependencies.dependenciesOf((Object[])new Object[]{fileSystem, config, logService, pageCache, nonListenableMonitors, jobScheduler, tokenHolders, recoveryCleanupCollector, tracers, databaseLayout, readOnlyChecker, availabilityGuard, namedDatabaseId, FileStoreProviderRegistry.EMPTY, contextFactory, databaseHealth});
        DatabaseExtensionContext extensionContext = new DatabaseExtensionContext(databaseLayout, info, (DependencySatisfier)deps);
        return new DatabaseExtensions(extensionContext, recoveryExtensions, deps, ExtensionFailureStrategies.fail());
    }

    private static PageCache getPageCache(Config config, FileSystemAbstraction fs, JobScheduler jobScheduler) {
        ConfiguringPageCacheFactory pageCacheFactory = new ConfiguringPageCacheFactory(fs, config, PageCacheTracer.NULL, (InternalLog)NullLog.getInstance(), jobScheduler, Clocks.nanoClock(), new MemoryPools());
        return pageCacheFactory.getOrCreatePageCache();
    }

    static void throwUnableToCleanRecover(Throwable t) {
        throw new RuntimeException("Error reading transaction logs, recovery not possible. To force the database to start anyway, you can specify '" + GraphDatabaseInternalSettings.fail_on_corrupted_log_files.name() + "=false'. This will try to recover as much as possible and then truncate the corrupt part of the transaction log. Doing this means your database integrity might be compromised, please consider restoring from a consistent backup instead.", t);
    }

    public static class Context {
        private final MemoryTracker memoryTracker;
        private final DatabaseLayout databaseLayout;
        private final FileSystemAbstraction fs;
        private final PageCache pageCache;
        private final Config config;
        private final DatabaseTracers tracers;
        private final InternalLogProvider logProvider;
        private boolean rollbackIncompleteTransactions = true;
        private boolean forceRunRecovery;
        private Monitors globalMonitors = new Monitors();
        private Iterable<ExtensionFactory<?>> extensionFactories;
        private Optional<LogTailMetadata> providedLogTail = Optional.empty();
        private RecoveryStartupChecker startupChecker = RecoveryStartupChecker.EMPTY_CHECKER;
        private Clock clock = Clocks.systemClock();
        private final IOController ioController;
        private RecoveryPredicate recoveryPredicate = RecoveryPredicate.ALL;
        private RecoveryMode mode = RecoveryMode.FULL;
        private long awaitIndexesOnlineMillis;
        private final KernelVersionProvider emptyLogsFallbackKernelVersion;

        private Context(FileSystemAbstraction fileSystemAbstraction, PageCache pageCache, DatabaseLayout databaseLayout, Config config, MemoryTracker memoryTracker, DatabaseTracers tracers, IOController ioController, InternalLogProvider logProvider, KernelVersionProvider emptyLogsFallbackKernelVersion) {
            Objects.requireNonNull(pageCache);
            Objects.requireNonNull(fileSystemAbstraction);
            Objects.requireNonNull(databaseLayout);
            Objects.requireNonNull(config);
            this.pageCache = pageCache;
            this.fs = fileSystemAbstraction;
            this.databaseLayout = databaseLayout;
            this.config = config;
            this.memoryTracker = memoryTracker;
            this.tracers = tracers;
            this.ioController = ioController;
            this.logProvider = Objects.requireNonNull(logProvider);
            this.emptyLogsFallbackKernelVersion = emptyLogsFallbackKernelVersion;
        }

        private Context(FileSystemAbstraction fileSystemAbstraction, PageCache pageCache, DatabaseLayout databaseLayout, Config config, MemoryTracker memoryTracker, DatabaseTracers tracers, IOController ioController, InternalLogProvider logProvider, LogTailMetadata logTail) {
            Objects.requireNonNull(pageCache);
            Objects.requireNonNull(fileSystemAbstraction);
            Objects.requireNonNull(databaseLayout);
            Objects.requireNonNull(config);
            this.pageCache = pageCache;
            this.fs = fileSystemAbstraction;
            this.databaseLayout = databaseLayout;
            this.config = config;
            this.memoryTracker = memoryTracker;
            this.tracers = tracers;
            this.ioController = ioController;
            this.logProvider = Objects.requireNonNull(logProvider);
            this.emptyLogsFallbackKernelVersion = KernelVersionProvider.THROWING_PROVIDER;
            this.providedLogTail = Optional.of(logTail);
        }

        public Context monitors(Monitors monitors) {
            this.globalMonitors = monitors;
            return this;
        }

        public Context extensionFactories(Iterable<ExtensionFactory<?>> extensionFactories) {
            this.extensionFactories = extensionFactories;
            return this;
        }

        public Context force() {
            this.forceRunRecovery = true;
            return this;
        }

        public Context startupChecker(RecoveryStartupChecker startupChecker) {
            this.startupChecker = startupChecker;
            return this;
        }

        public Context clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Context recoveryPredicate(RecoveryPredicate recoveryPredicate) {
            this.recoveryPredicate = recoveryPredicate;
            return this;
        }

        public Context awaitIndexesOnline(long time, TimeUnit unit) {
            this.awaitIndexesOnlineMillis = unit.toMillis(time);
            return this;
        }

        public Context recoveryMode(RecoveryMode mode) {
            this.mode = mode;
            return this;
        }

        public Context rollbackIncompleteTransactions(boolean rollbackIncompleteTransactions) {
            this.rollbackIncompleteTransactions = rollbackIncompleteTransactions;
            return this;
        }
    }

    private static class RecoveryAvailabilityGuard
    extends DatabaseAvailabilityGuard {
        RecoveryAvailabilityGuard(NamedDatabaseId namedDatabaseId, Clock clock, InternalLog log) {
            super(namedDatabaseId, clock, log, 0L, new CompositeDatabaseAvailabilityGuard(clock, Config.defaults()));
            this.init();
            this.start();
        }

        @Override
        public void addListener(AvailabilityListener listener) {
            super.addListener(listener);
            listener.available();
        }
    }

    private static class MissingTransactionLogsCheck
    extends LifecycleAdapter {
        private final Config config;
        private final LogTailMetadata logTail;
        private final InternalLog log;

        MissingTransactionLogsCheck(Config config, LogTailMetadata logTail, InternalLog log) {
            this.config = config;
            this.logTail = logTail;
            this.log = log;
        }

        public void init() {
            this.checkForMissingLogFiles();
        }

        private void checkForMissingLogFiles() {
            if (this.logTail.logsMissing()) {
                if (((Boolean)this.config.get(GraphDatabaseSettings.fail_on_missing_files)).booleanValue()) {
                    this.log.error("Transaction logs are missing and recovery is not possible.");
                    this.log.info("To force the database to start anyway, you can specify '%s=false'. This will create new transaction log and will update database metadata accordingly. Doing this means your database integrity might be compromised, please consider restoring from a consistent backup instead.", new Object[]{GraphDatabaseSettings.fail_on_missing_files.name()});
                    throw new RuntimeException("Transaction logs are missing and recovery is not possible.");
                }
                this.log.warn("No transaction logs were detected, but recovery was forced by user.");
            }
        }
    }

    private static class NonListenableMonitors
    extends Monitors {
        NonListenableMonitors(Monitors monitors, InternalLogProvider logProvider) {
            super(monitors, logProvider);
        }

        public void addMonitorListener(Object monitorListener, String ... tags) {
        }
    }
}

