/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files.checkpoint;

import java.io.IOException;
import org.neo4j.kernel.BinarySupportedKernelVersions;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.AppendBatchInfo;
import org.neo4j.kernel.impl.transaction.log.LastAppendBatchInfoProvider;
import org.neo4j.kernel.impl.transaction.log.LogEntryCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.UnsupportedLogVersionException;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.v57.LogEntryChunkEnd;
import org.neo4j.kernel.impl.transaction.log.entry.v57.LogEntryChunkStart;
import org.neo4j.kernel.impl.transaction.log.entry.v57.LogEntryRollback;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.storageengine.api.CommandReaderFactory;

public class DetachedLogTailAppendIndexProvider
implements LastAppendBatchInfoProvider {
    private final LogFile logFile;
    private final KernelVersion kernelVersion;
    private final long startingAppendIndex;
    private final LogPosition logPosition;
    private final BinarySupportedKernelVersions binarySupportedKernelVersions;
    private final CommandReaderFactory commandReaderFactory;

    public DetachedLogTailAppendIndexProvider(CommandReaderFactory commandReaderFactory, BinarySupportedKernelVersions binarySupportedKernelVersions, LogFile logFile, KernelVersion kernelVersion, long startingAppendIndex, LogPosition logPosition) {
        this.logFile = logFile;
        this.kernelVersion = kernelVersion;
        this.startingAppendIndex = startingAppendIndex;
        this.logPosition = logPosition;
        this.binarySupportedKernelVersions = binarySupportedKernelVersions;
        this.commandReaderFactory = commandReaderFactory;
    }

    public AppendBatchInfo get() {
        if (this.logPosition != null && this.logPosition != LogPosition.UNSPECIFIED) {
            long logVersion = this.logPosition.getLogVersion();
            boolean checkCommitEntries = this.kernelVersion.isLessThan(KernelVersion.VERSION_APPEND_INDEX_INTRODUCED);
            long appendIndex = this.startingAppendIndex;
            LogPosition postLogPosition = this.logPosition;
            try {
                while (this.logFile.versionExists(logVersion)) {
                    LogPosition lookupPosition = DetachedLogTailAppendIndexProvider.getLookupPosition(this.logFile, this.logPosition, logVersion);
                    if (lookupPosition == LogPosition.UNSPECIFIED) {
                        return new AppendBatchInfo(appendIndex, postLogPosition);
                    }
                    VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader(this.commandReaderFactory, this.binarySupportedKernelVersions);
                    try (ReadableLogChannel reader = this.logFile.getReader(lookupPosition, LogVersionBridge.NO_MORE_CHANNELS);
                         LogEntryCursor cursor = new LogEntryCursor((LogEntryReader)logEntryReader, (ReadableLogPositionAwareChannel)reader);){
                        long currentAppendIndex = 0L;
                        while (cursor.next()) {
                            LogEntry entry = cursor.get();
                            if (entry instanceof LogEntryStart) {
                                LogEntryStart startEntry = (LogEntryStart)entry;
                                currentAppendIndex = startEntry.getAppendIndex();
                                continue;
                            }
                            if (entry instanceof LogEntryChunkStart) {
                                LogEntryChunkStart chunkStart = (LogEntryChunkStart)entry;
                                currentAppendIndex = chunkStart.getAppendIndex();
                                continue;
                            }
                            if (entry instanceof LogEntryRollback) {
                                LogEntryRollback rollback = (LogEntryRollback)entry;
                                assert (currentAppendIndex == 0L);
                                appendIndex = rollback.getAppendIndex();
                                postLogPosition = reader.getCurrentLogPosition();
                                continue;
                            }
                            if (!(entry instanceof LogEntryChunkEnd) && !(entry instanceof LogEntryCommit)) continue;
                            if (checkCommitEntries && entry instanceof LogEntryCommit) {
                                LogEntryCommit commit = (LogEntryCommit)entry;
                                currentAppendIndex = commit.getTxId();
                            }
                            assert (currentAppendIndex != 0L);
                            appendIndex = currentAppendIndex;
                            postLogPosition = reader.getCurrentLogPosition();
                            currentAppendIndex = 0L;
                        }
                    }
                    catch (IOException | IllegalStateException | UnsupportedLogVersionException e) {
                        return new AppendBatchInfo(appendIndex, postLogPosition);
                    }
                    ++logVersion;
                }
                return new AppendBatchInfo(appendIndex, postLogPosition);
            }
            catch (Throwable t) {
                throw new RuntimeException("Unable to retrieve last append index", t);
            }
        }
        return new AppendBatchInfo(this.startingAppendIndex, LogPosition.UNSPECIFIED);
    }

    private static LogPosition getLookupPosition(LogFile logFile, LogPosition logPosition, long logVersion) {
        if (logVersion == logPosition.getLogVersion()) {
            return logPosition;
        }
        try {
            LogHeader logHeader = logFile.extractHeader(logVersion);
            if (logHeader != null) {
                return logHeader.getStartPosition();
            }
        }
        catch (IOException e) {
            return LogPosition.UNSPECIFIED;
        }
        return LogPosition.UNSPECIFIED;
    }
}

