/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Iterator;
import org.neo4j.collection.PrimitiveArrays;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.internal.schema.FulltextSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.storageengine.api.txstate.TransactionStateBehaviour;

public class SchemaMatcher {
    private SchemaMatcher() {
        throw new AssertionError((Object)"no instance");
    }

    static <SUPPLIER extends SchemaDescriptorSupplier, EXCEPTION extends Exception> void onMatchingSchema(Iterator<SUPPLIER> schemaSuppliers, int specialPropertyId, int[] existingPropertyIds, TransactionStateBehaviour stateBehaviour, ThrowingConsumer<SUPPLIER, EXCEPTION> callback) throws EXCEPTION {
        while (schemaSuppliers.hasNext()) {
            SchemaDescriptorSupplier schemaSupplier = (SchemaDescriptorSupplier)schemaSuppliers.next();
            SchemaDescriptor schema = schemaSupplier.schema();
            if (stateBehaviour.useIndexCommands() && schema.isSchemaDescriptorType(FulltextSchemaDescriptor.class)) {
                if (!PrimitiveArrays.contains((int[])schema.getPropertyIds(), (int)specialPropertyId) && specialPropertyId >= 0) continue;
                callback.accept((Object)schemaSupplier);
                continue;
            }
            if (!SchemaMatcher.entityHasSchemaProperties(existingPropertyIds, schema.getPropertyIds(), specialPropertyId)) continue;
            callback.accept((Object)schemaSupplier);
        }
    }

    private static boolean entityHasSchemaProperties(int[] existingPropertyIds, int[] indexPropertyIds, int changedPropertyId) {
        for (int indexPropertyId : indexPropertyIds) {
            if (indexPropertyId == changedPropertyId || PrimitiveArrays.contains((int[])existingPropertyIds, (int)indexPropertyId)) continue;
            return false;
        }
        return true;
    }
}

