/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.Serializable;
import java.time.Clock;
import java.util.List;
import java.util.Objects;
import org.eclipse.collections.api.block.function.primitive.FloatToFloatFunction;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.factory.primitive.ObjectFloatMaps;
import org.eclipse.collections.api.map.primitive.MutableObjectFloatMap;
import org.eclipse.collections.api.set.MutableSet;
import org.neo4j.batchimport.api.IndexesCreator;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.Subject;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.exceptions.KernelException;
import org.neo4j.index.internal.gbptree.GroupingRecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.impl.muninn.VersionStorage;
import org.neo4j.io.pagecache.tracing.DatabaseFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.api.index.BulkIndexCreationContext;
import org.neo4j.kernel.impl.api.DatabaseSchemaState;
import org.neo4j.kernel.impl.api.TransactionVisibilityProvider;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.IndexingServiceFactory;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.index.DatabaseIndexStats;
import org.neo4j.kernel.impl.locking.LockManager;
import org.neo4j.kernel.impl.transaction.state.StaticIndexProviderMap;
import org.neo4j.kernel.impl.transaction.state.StaticIndexProviderMapFactory;
import org.neo4j.kernel.impl.transaction.state.storeview.FullScanStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.IndexStoreViewFactory;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.lock.LockService;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.ReadableStorageEngine;
import org.neo4j.time.Clocks;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.token.TokenHolders;
import org.neo4j.util.VisibleForTesting;

public class BulkIndexesCreator
implements IndexesCreator {
    private static final float ZERO = 0.0f;
    private final BulkIndexCreationContext context;
    private final Lifespan lifespan;
    private final IndexingService indexingService;

    public BulkIndexesCreator(BulkIndexCreationContext context) throws IOException {
        this.context = Objects.requireNonNull(context);
        this.lifespan = Lifespan.createWithNoneState((Lifecycle[])new Lifecycle[0]);
        this.indexingService = this.createIndexingService((LifeSupport)this.lifespan, context);
        this.lifespan.start();
    }

    public IndexDescriptor completeConfiguration(IndexDescriptor index) {
        return this.indexingService.completeConfiguration(index);
    }

    public void create(IndexesCreator.CreationListener creationListener, List<IndexDescriptor> indexDescriptors) throws IOException {
        int descriptorCount = indexDescriptors.size();
        if (descriptorCount == 0) {
            return;
        }
        this.indexingService.createIndexes(Subject.SYSTEM, (IndexDescriptor[])indexDescriptors.stream().map(this.indexingService::completeConfiguration).toArray(IndexDescriptor[]::new));
        boolean noErrors = true;
        MutableObjectFloatMap progressTracker = ObjectFloatMaps.mutable.empty();
        MutableSet seenIndexes = Sets.mutable.empty();
        while (seenIndexes.size() < descriptorCount) {
            for (IndexProxy indexProxy : this.indexingService.getIndexProxies()) {
                IndexDescriptor descriptor = indexProxy.getDescriptor();
                if (seenIndexes.contains((Object)descriptor)) continue;
                InternalIndexState state = indexProxy.getState();
                if (state == InternalIndexState.FAILED) {
                    noErrors = false;
                    seenIndexes.add((Object)descriptor);
                    creationListener.onFailure(descriptor, (KernelException)indexProxy.getPopulationFailure().asIndexPopulationFailure(descriptor.schema(), descriptor.userDescription((TokenNameLookup)this.context.tokenHolders())));
                    continue;
                }
                float latestProgress = indexProxy.getIndexPopulationProgress().getProgress();
                progressTracker.updateValue((Object)descriptor, 0.0f, (FloatToFloatFunction & Serializable)lastProgress -> {
                    if (lastProgress > 0.0f) {
                        float delta = latestProgress - lastProgress;
                        if (delta > 0.0f) {
                            creationListener.onUpdate(descriptor, delta);
                        }
                    } else if (latestProgress > 0.0f) {
                        creationListener.onUpdate(descriptor, latestProgress);
                    }
                    return latestProgress;
                });
                if (state != InternalIndexState.ONLINE && latestProgress != 1.0f) continue;
                seenIndexes.add((Object)descriptor);
            }
            BulkIndexesCreator.sleepIgnoreInterrupt();
        }
        creationListener.onCreationCompleted(noErrors);
        if (noErrors) {
            try (CursorContext creationContext = this.context.contextFactory().create("Indexing flushing");
                 DatabaseFlushEvent flushEvent = this.context.pageCacheTracer().beginDatabaseFlush();){
                this.indexingService.checkpoint(flushEvent, creationContext);
                creationListener.onCheckpointingCompleted();
            }
        }
    }

    public void close() {
        this.lifespan.close();
    }

    @VisibleForTesting
    protected IndexingService createIndexingService(LifeSupport life, BulkIndexCreationContext context) throws IOException {
        SystemNanoClock clock = Clocks.nanoClock();
        DatabaseReadOnlyChecker readOnlyChecker = DatabaseReadOnlyChecker.writable();
        LogService logService = context.logService();
        InternalLogProvider logProvider = logService.getInternalLogProvider();
        JobScheduler jobScheduler = context.jobScheduler();
        DatabaseLayout databaseLayout = context.databaseLayout();
        Config config = context.config();
        PageCache pageCache = context.pageCache();
        FileSystemAbstraction fileSystem = context.fileSystem();
        TokenHolders tokenHolders = context.tokenHolders();
        CursorContextFactory contextFactory = context.contextFactory();
        PageCacheTracer pageCacheTracer = context.pageCacheTracer();
        ReadableStorageEngine storageEngine = context.storageEngine();
        GroupingRecoveryCleanupWorkCollector cleanupCollector = (GroupingRecoveryCleanupWorkCollector)life.add((Lifecycle)new GroupingRecoveryCleanupWorkCollector(jobScheduler, Group.INDEX_POPULATION, Group.INDEX_POPULATION_WORK, databaseLayout.getDatabaseName()));
        Dependencies indexDependencies = new Dependencies();
        indexDependencies.satisfyDependencies(new Object[]{VersionStorage.EMPTY_STORAGE});
        StaticIndexProviderMap indexProviderMap = (StaticIndexProviderMap)life.add((Lifecycle)StaticIndexProviderMapFactory.create(life, config, pageCache, fileSystem, logService, new Monitors(), readOnlyChecker, TopologyGraphDbmsModel.HostedOnMode.SINGLE, (RecoveryCleanupWorkCollector)cleanupCollector, databaseLayout, tokenHolders, jobScheduler, contextFactory, pageCacheTracer, (DependencyResolver)indexDependencies));
        FullScanStoreView fullScanStoreView = new FullScanStoreView(LockService.NO_LOCK_SERVICE, storageEngine, config, jobScheduler);
        IndexStoreViewFactory indexStoreViewFactory = new IndexStoreViewFactory(config, storageEngine, LockManager.NO_LOCKS_LOCK_MANAGER, fullScanStoreView, LockService.NO_LOCK_SERVICE, logProvider);
        IndexStatisticsStore indexStatisticsStore = (IndexStatisticsStore)life.add((Lifecycle)new IndexStatisticsStore(pageCache, fileSystem, databaseLayout.indexStatisticsStore(), RecoveryCleanupWorkCollector.immediate(), false, databaseLayout.getDatabaseName(), contextFactory, pageCacheTracer, storageEngine.getOpenOptions()));
        return (IndexingService)life.add((Lifecycle)IndexingServiceFactory.createIndexingService(storageEngine, config, jobScheduler, indexProviderMap, indexStoreViewFactory, (TokenNameLookup)tokenHolders, context.elementIdMapper(), List.of(), logService.getInternalLogProvider(), IndexMonitor.NO_MONITOR, new DatabaseSchemaState(logProvider), indexStatisticsStore, new DatabaseIndexStats(), contextFactory, context.memoryTracker(), databaseLayout.getDatabaseName(), readOnlyChecker, (Clock)clock, (KernelVersionProvider)context.metadataCache(), fileSystem, TransactionVisibilityProvider.EMPTY_VISIBILITY_PROVIDER));
    }

    private static void sleepIgnoreInterrupt() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

