/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.query;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.internal.kernel.api.ExecutionStatistics;
import org.neo4j.util.VisibleForTesting;

public interface QueryTransactionStatisticsAggregator {
    public void recordStatisticsOfTransactionAboutToClose(long var1, long var3, long var5);

    public void recordStatisticsOfClosedTransaction(long var1, long var3, long var5, CommitPhaseStatisticsListener var7);

    public long pageHitsOfClosedTransactions();

    public long pageFaultsOfClosedTransactions();

    public long pageHitsOfClosedTransactionCommits();

    public long pageFaultsOfClosedTransactionCommits();

    @VisibleForTesting
    public ExecutionStatistics statisticsOfClosedTransactionsExcludingCommits();

    @VisibleForTesting
    public ExecutionStatistics statisticsOfClosedTransactionCommits();

    @FunctionalInterface
    public static interface CommitPhaseStatisticsListener {
        public static final CommitPhaseStatisticsListener NO_OP = (pageHits, pageFaults, transactionSequenceNumber) -> {};

        public void onRecordedStatisticsOfCommitPhase(long var1, long var3, long var5);
    }

    public static class Stats
    implements ExecutionStatistics {
        long hits;
        long faults;
        long transactionSequenceNumber;

        Stats(long hits, long faults, long transactionSequenceNumber) {
            this.hits = hits;
            this.faults = faults;
            this.transactionSequenceNumber = transactionSequenceNumber;
        }

        public long pageHits() {
            return this.hits;
        }

        public long pageFaults() {
            return this.faults;
        }

        public long getTransactionSequenceNumber() {
            return this.transactionSequenceNumber;
        }
    }

    public static class ConcurrentImpl
    implements QueryTransactionStatisticsAggregator {
        private final Map<Long, Stats> pageStatsExcludingCommits = new ConcurrentHashMap<Long, Stats>();
        private final AtomicReference<Stats> statsOfClosedTransactionsExcludingCommits = new AtomicReference<Stats>(new Stats(0L, 0L, 0L));
        private final AtomicReference<Stats> statsOfClosedTransactionCommits = new AtomicReference<Stats>(new Stats(0L, 0L, 0L));

        public ConcurrentImpl() {
        }

        public ConcurrentImpl(QueryTransactionStatisticsAggregator statistics) {
            long hitsIncluding = statistics.pageHitsOfClosedTransactions();
            long faultsIncluding = statistics.pageFaultsOfClosedTransactions();
            long hitsOfCommits = statistics.pageHitsOfClosedTransactionCommits();
            long faultsOfCommits = statistics.pageFaultsOfClosedTransactionCommits();
            long hitsExcluding = hitsIncluding - hitsOfCommits;
            long faultsExcluding = faultsIncluding - faultsOfCommits;
            Stats statsExcludingCommits = this.statsOfClosedTransactionsExcludingCommits.get();
            Stats statsOfCommits = this.statsOfClosedTransactionCommits.get();
            statsExcludingCommits.hits = hitsExcluding;
            statsExcludingCommits.faults = faultsExcluding;
            statsOfCommits.hits = hitsOfCommits;
            statsOfCommits.faults = faultsOfCommits;
        }

        @Override
        public void recordStatisticsOfTransactionAboutToClose(long hits, long faults, long transactionSequenceNumber) {
            Stats stats = this.pageStatsExcludingCommits.get(transactionSequenceNumber);
            if (stats == null) {
                this.pageStatsExcludingCommits.put(transactionSequenceNumber, new Stats(hits, faults, transactionSequenceNumber));
            } else {
                stats.hits += hits;
                stats.faults += faults;
            }
            ConcurrentImpl.updateStats(this.statsOfClosedTransactionsExcludingCommits, hits, faults, transactionSequenceNumber);
        }

        @Override
        public void recordStatisticsOfClosedTransaction(long hits, long faults, long transactionSequenceNumber, CommitPhaseStatisticsListener listener) {
            Stats excludingCommitsStats = this.pageStatsExcludingCommits.remove(transactionSequenceNumber);
            if (excludingCommitsStats == null) {
                throw new IllegalStateException("Expected to find recorded page cache statistics for transaction sequence number " + transactionSequenceNumber + " on thread " + Thread.currentThread().getName());
            }
            long hitsDuringCommit = hits - excludingCommitsStats.hits;
            long faultsDuringCommit = faults - excludingCommitsStats.faults;
            listener.onRecordedStatisticsOfCommitPhase(hitsDuringCommit, faultsDuringCommit, transactionSequenceNumber);
            ConcurrentImpl.updateStats(this.statsOfClosedTransactionCommits, hitsDuringCommit, faultsDuringCommit, transactionSequenceNumber);
        }

        private static void updateStats(AtomicReference<Stats> stats, long hits, long faults, long transactionSequenceNumber) {
            Stats current;
            Stats updated = new Stats(0L, 0L, transactionSequenceNumber);
            do {
                current = stats.get();
                updated.hits = current.hits + hits;
                updated.faults = current.faults + faults;
                long currentSequenceNumber = current.transactionSequenceNumber;
                if (currentSequenceNumber <= transactionSequenceNumber) continue;
                updated.transactionSequenceNumber = currentSequenceNumber;
            } while (!stats.weakCompareAndSetVolatile(current, updated));
        }

        @Override
        public long pageHitsOfClosedTransactions() {
            return this.statsOfClosedTransactionsExcludingCommits.get().hits + this.statsOfClosedTransactionCommits.get().hits;
        }

        @Override
        public long pageFaultsOfClosedTransactions() {
            return this.statsOfClosedTransactionsExcludingCommits.get().faults + this.statsOfClosedTransactionCommits.get().faults;
        }

        @Override
        public long pageHitsOfClosedTransactionCommits() {
            return this.statsOfClosedTransactionCommits.get().hits;
        }

        @Override
        public long pageFaultsOfClosedTransactionCommits() {
            return this.statsOfClosedTransactionCommits.get().faults;
        }

        @Override
        public ExecutionStatistics statisticsOfClosedTransactionsExcludingCommits() {
            return this.statsOfClosedTransactionsExcludingCommits.get();
        }

        @Override
        public ExecutionStatistics statisticsOfClosedTransactionCommits() {
            return this.statsOfClosedTransactionCommits.get();
        }
    }

    public static class DefaultImpl
    implements QueryTransactionStatisticsAggregator {
        private volatile long pageHitsOfClosedTransactionsExcludingCommits;
        private volatile long pageFaultsOfClosedTransactionsExcludingCommits;
        private volatile long pageHitsOfClosedTransactionsIncludingCommits;
        private volatile long pageFaultsOfClosedTransactionsIncludingCommits;
        private volatile long pageHitsOfClosedTransactionCommits;
        private volatile long pageFaultsOfClosedTransactionCommits;

        @Override
        public void recordStatisticsOfTransactionAboutToClose(long hits, long faults, long transactionSequenceNumber) {
            this.pageHitsOfClosedTransactionsExcludingCommits += hits;
            this.pageFaultsOfClosedTransactionsExcludingCommits += faults;
        }

        @Override
        public void recordStatisticsOfClosedTransaction(long hits, long faults, long transactionSequenceNumber, CommitPhaseStatisticsListener listener) {
            this.pageHitsOfClosedTransactionsIncludingCommits += hits;
            this.pageFaultsOfClosedTransactionsIncludingCommits += faults;
            this.pageHitsOfClosedTransactionCommits = this.pageHitsOfClosedTransactionsIncludingCommits - this.pageHitsOfClosedTransactionsExcludingCommits;
            this.pageFaultsOfClosedTransactionCommits = this.pageFaultsOfClosedTransactionsIncludingCommits - this.pageFaultsOfClosedTransactionsExcludingCommits;
            listener.onRecordedStatisticsOfCommitPhase(this.pageHitsOfClosedTransactionCommits, this.pageFaultsOfClosedTransactionCommits, transactionSequenceNumber);
        }

        @Override
        public long pageHitsOfClosedTransactions() {
            return this.pageHitsOfClosedTransactionsExcludingCommits + this.pageHitsOfClosedTransactionCommits;
        }

        @Override
        public long pageFaultsOfClosedTransactions() {
            return this.pageFaultsOfClosedTransactionsExcludingCommits + this.pageFaultsOfClosedTransactionCommits;
        }

        @Override
        public long pageHitsOfClosedTransactionCommits() {
            return this.pageHitsOfClosedTransactionCommits;
        }

        @Override
        public long pageFaultsOfClosedTransactionCommits() {
            return this.pageFaultsOfClosedTransactionCommits;
        }

        @Override
        public ExecutionStatistics statisticsOfClosedTransactionsExcludingCommits() {
            return new Stats(this.pageHitsOfClosedTransactionsExcludingCommits, this.pageFaultsOfClosedTransactionsExcludingCommits, 0L);
        }

        @Override
        public ExecutionStatistics statisticsOfClosedTransactionCommits() {
            return new Stats(this.pageHitsOfClosedTransactionCommits, this.pageFaultsOfClosedTransactionCommits, 0L);
        }
    }
}

