/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.factory;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.connectioninfo.RoutingInfo;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.availability.UnavailableException;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.api.CloseableResourceManager;
import org.neo4j.kernel.impl.coreapi.DefaultTransactionExceptionMapper;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.TransactionExceptionMapper;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.factory.FacadeKernelTransactionFactory;
import org.neo4j.kernel.impl.factory.GraphDatabaseTransactions;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContextFactory;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class GraphDatabaseFacade
extends GraphDatabaseTransactions
implements GraphDatabaseAPI {
    private final Database database;
    protected final TransactionalContextFactory contextFactory;
    private final DatabaseAvailabilityGuard availabilityGuard;
    private final TopologyGraphDbmsModel.HostedOnMode mode;
    private final DbmsInfo dbmsInfo;

    public GraphDatabaseFacade(Database database, Config config, DbmsInfo dbmsInfo, TopologyGraphDbmsModel.HostedOnMode mode, TransactionalContext.DatabaseMode databaseMode, DatabaseAvailabilityGuard availabilityGuard) {
        super(config);
        this.database = Objects.requireNonNull(database);
        this.availabilityGuard = Objects.requireNonNull(availabilityGuard);
        this.dbmsInfo = Objects.requireNonNull(dbmsInfo);
        this.mode = Objects.requireNonNull(mode);
        this.contextFactory = Neo4jTransactionalContextFactory.create(() -> (GraphDatabaseQueryService)this.getDependencyResolver().resolveDependency(GraphDatabaseQueryService.class), new FacadeKernelTransactionFactory(config, this), databaseMode);
    }

    public boolean isAvailable() {
        return this.database.getDatabaseAvailabilityGuard().isAvailable();
    }

    public boolean isAvailable(long timeoutMillis) {
        return this.database.getDatabaseAvailabilityGuard().isAvailable(timeoutMillis);
    }

    @Override
    public InternalTransaction beginTransaction(KernelTransaction.Type type, LoginContext loginContext, ClientConnectionInfo clientInfo, long timeout, TimeUnit unit) {
        return this.beginTransactionInternal(type, loginContext, clientInfo, null, unit.toMillis(timeout), null, DefaultTransactionExceptionMapper.INSTANCE);
    }

    @Override
    public InternalTransaction beginTransaction(KernelTransaction.Type type, LoginContext loginContext, ClientConnectionInfo clientInfo, RoutingInfo routingInfo, long timeout, TimeUnit unit, Consumer<Status> terminationCallback, TransactionExceptionMapper transactionExceptionMapper) {
        return this.beginTransactionInternal(type, loginContext, clientInfo, routingInfo, unit.toMillis(timeout), terminationCallback, transactionExceptionMapper);
    }

    protected InternalTransaction beginTransactionInternal(KernelTransaction.Type type, LoginContext loginContext, ClientConnectionInfo connectionInfo, RoutingInfo routingInfo, long timeoutMillis, Consumer<Status> terminationCallback, TransactionExceptionMapper transactionExceptionMapper) {
        KernelTransaction kernelTransaction = this.beginKernelTransaction(type, loginContext, connectionInfo, timeoutMillis);
        return new TransactionImpl(this.database.getTokenHolders(), this.contextFactory, this.availabilityGuard, this.database.getExecutionEngine(), kernelTransaction, new CloseableResourceManager(), terminationCallback, transactionExceptionMapper, this.database.getElementIdMapper(), routingInfo);
    }

    @Override
    public NamedDatabaseId databaseId() {
        return this.database.getNamedDatabaseId();
    }

    @Override
    public DbmsInfo dbmsInfo() {
        return this.dbmsInfo;
    }

    @Override
    public TopologyGraphDbmsModel.HostedOnMode mode() {
        return this.mode;
    }

    KernelTransaction beginKernelTransaction(KernelTransaction.Type type, LoginContext loginContext, ClientConnectionInfo connectionInfo, long timeout) {
        try {
            this.availabilityGuard.assertDatabaseAvailable();
            return this.database.getKernel().beginTransaction(type, loginContext, connectionInfo, timeout);
        }
        catch (TransactionFailureException | UnavailableException e) {
            throw new org.neo4j.graphdb.TransactionFailureException(e.getMessage(), (Throwable)e, ((Status.HasStatus)e).status());
        }
    }

    public String databaseName() {
        return this.databaseId().name();
    }

    @Override
    public DependencyResolver getDependencyResolver() {
        return this.database.getDependencyResolver();
    }

    @Override
    public DatabaseLayout databaseLayout() {
        return this.database.getDatabaseLayout();
    }

    public String toString() {
        return this.dbmsInfo + "/" + this.mode + " [" + this.databaseLayout() + "]";
    }
}

