/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.transaction.monitor;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.neo4j.configuration.Config;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.TerminationMark;
import org.neo4j.kernel.api.TransactionTimeout;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.api.TransactionVisibilityProvider;
import org.neo4j.kernel.impl.api.transaction.monitor.TransactionMonitor;
import org.neo4j.kernel.impl.api.transaction.trace.TransactionInitializationTrace;
import org.neo4j.logging.internal.LogService;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.time.SystemNanoClock;

public class KernelTransactionMonitor
extends TransactionMonitor<MonitoredKernelTransaction>
implements TransactionVisibilityProvider {
    private final KernelTransactions kernelTransactions;
    private final TransactionIdStore transactionIdStore;
    private final AtomicLong oldestVisibilityBoundary = new AtomicLong(1L);
    private final AtomicLong oldestVisibleClosedTransactionId = new AtomicLong(1L);

    public KernelTransactionMonitor(KernelTransactions kernelTransactions, TransactionIdStore transactionIdStore, Config config, SystemNanoClock clock, LogService logService) {
        super(config, clock, logService);
        this.kernelTransactions = kernelTransactions;
        this.transactionIdStore = transactionIdStore;
        this.oldestVisibleClosedTransactionId.setRelease(transactionIdStore.getHighestEverClosedTransaction().id());
        this.oldestVisibilityBoundary.setRelease(transactionIdStore.getHighestEverClosedTransaction().id());
    }

    @Override
    protected void updateTransactionBoundaries() {
        long oldestOpenTransactionId = this.transactionIdStore.getLastClosedTransactionId();
        Set<KernelTransactionHandle> executingTransactions = this.kernelTransactions.executingTransactions();
        long oldestTxId = oldestOpenTransactionId;
        long oldestHorizon = oldestOpenTransactionId;
        for (KernelTransactionHandle txHandle : executingTransactions) {
            if (!txHandle.terminationMark().isEmpty()) continue;
            oldestTxId = Math.min(oldestTxId, txHandle.getLastClosedTxId());
            oldestHorizon = Math.min(oldestHorizon, txHandle.getTransactionHorizon());
        }
        this.oldestVisibleClosedTransactionId.setRelease(oldestTxId);
        this.oldestVisibilityBoundary.setRelease(oldestHorizon);
    }

    @Override
    protected Set<MonitoredKernelTransaction> getActiveTransactions() {
        return this.kernelTransactions.activeTransactions().stream().map(MonitoredKernelTransaction::new).collect(Collectors.toSet());
    }

    @Override
    public long oldestVisibleClosedTransactionId() {
        return this.oldestVisibleClosedTransactionId.getAcquire();
    }

    @Override
    public long oldestObservableHorizon() {
        return this.oldestVisibilityBoundary.getAcquire();
    }

    @Override
    public long youngestObservableHorizon() {
        long youngestHorizon = Long.MIN_VALUE;
        for (MonitoredKernelTransaction monitoredTx : this.getActiveTransactions()) {
            if (!monitoredTx.terminationMark().isEmpty()) continue;
            youngestHorizon = Math.max(youngestHorizon, monitoredTx.kernelTransaction.getTransactionHorizon());
        }
        return youngestHorizon;
    }

    static class MonitoredKernelTransaction
    implements TransactionMonitor.MonitoredTransaction {
        private final KernelTransactionHandle kernelTransaction;

        private MonitoredKernelTransaction(KernelTransactionHandle kernelTransaction) {
            this.kernelTransaction = kernelTransaction;
        }

        @Override
        public long startTimeNanos() {
            return this.kernelTransaction.startTimeNanos();
        }

        @Override
        public TransactionTimeout timeout() {
            return this.kernelTransaction.timeout();
        }

        @Override
        public Optional<TerminationMark> terminationMark() {
            return this.kernelTransaction.terminationMark();
        }

        @Override
        public boolean isSchemaTransaction() {
            return this.kernelTransaction.isSchemaTransaction();
        }

        @Override
        public boolean markForTermination(Status reason) {
            return this.kernelTransaction.markForTermination(reason);
        }

        @Override
        public String getIdentifyingDescription() {
            return this.kernelTransaction.toString();
        }

        @Override
        public TransactionInitializationTrace transactionInitialisationTrace() {
            return this.kernelTransaction.transactionInitialisationTrace();
        }
    }
}

