/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery.facade;

import java.io.IOException;
import org.neo4j.configuration.Config;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.IOController;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.kernel.recovery.RecoveryMode;
import org.neo4j.kernel.recovery.facade.RecoveryCriteria;
import org.neo4j.kernel.recovery.facade.RecoveryFacade;
import org.neo4j.kernel.recovery.facade.RecoveryFacadeMonitor;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.MemoryTracker;

public class DatabaseRecoveryFacade
implements RecoveryFacade {
    private final FileSystemAbstraction fs;
    private final PageCache pageCache;
    private final DatabaseTracers tracers;
    private final Config config;
    private final MemoryTracker memoryTracker;
    private final InternalLogProvider logProvider;
    private final KernelVersionProvider emptyLogsFallbackKernelVersion;

    public DatabaseRecoveryFacade(FileSystemAbstraction fs, PageCache pageCache, DatabaseTracers tracers, Config config, MemoryTracker memoryTracker, InternalLogProvider logProvider, KernelVersionProvider emptyLogsFallbackKernelVersion) {
        this.fs = fs;
        this.pageCache = pageCache;
        this.tracers = tracers;
        this.config = config;
        this.memoryTracker = memoryTracker;
        this.logProvider = logProvider;
        this.emptyLogsFallbackKernelVersion = emptyLogsFallbackKernelVersion;
    }

    @Override
    public void performRecovery(DatabaseLayout layout, RecoveryCriteria recoveryCriteria, RecoveryFacadeMonitor recoveryFacadeMonitor, RecoveryMode recoveryMode) throws IOException {
        this.recovery(layout, recoveryCriteria, recoveryFacadeMonitor, recoveryMode);
    }

    @Override
    public void performRecovery(DatabaseLayout databaseLayout) throws IOException {
        this.performRecovery(databaseLayout, RecoveryFacadeMonitor.EMPTY_MONITOR, RecoveryMode.FULL);
    }

    @Override
    public void performRecovery(DatabaseLayout databaseLayout, RecoveryFacadeMonitor monitor, RecoveryMode mode) throws IOException {
        this.performRecovery(databaseLayout, RecoveryCriteria.ALL, monitor, mode);
    }

    @Override
    public void performRecovery(DatabaseLayout databaseLayout, RecoveryCriteria recoveryCriteria, RecoveryFacadeMonitor monitor) throws IOException {
        this.performRecovery(databaseLayout, recoveryCriteria, monitor, RecoveryMode.FULL);
    }

    private void recovery(DatabaseLayout databaseLayout, RecoveryCriteria recoveryCriteria, RecoveryFacadeMonitor monitor, RecoveryMode mode) throws IOException {
        monitor.recoveryStarted();
        Recovery.performRecovery(Recovery.context(this.fs, this.pageCache, this.tracers, this.config, databaseLayout, this.memoryTracker, IOController.DISABLED, this.logProvider, this.emptyLogsFallbackKernelVersion).recoveryPredicate(recoveryCriteria.toPredicate()).recoveryMode(mode));
        monitor.recoveryCompleted();
    }
}

