/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.util.Optional;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.impl.transaction.log.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogTailLogVersionsMetadata;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionId;

public class LogTailInformation
implements LogTailMetadata {
    public final CheckpointInfo lastCheckPoint;
    public final long firstTxIdAfterLastCheckPoint;
    public final boolean filesNotFound;
    public final long currentLogVersion;
    public final byte firstLogEntryVersionAfterCheckpoint;
    private final boolean recordAfterCheckpoint;
    private final StoreId storeId;
    private final KernelVersionProvider fallbackKernelVersionProvider;

    public LogTailInformation(boolean recordAfterCheckpoint, long firstTxIdAfterLastCheckPoint, boolean filesNotFound, long currentLogVersion, byte firstLogEntryVersionAfterCheckpoint, KernelVersionProvider fallbackKernelVersionProvider) {
        this(null, recordAfterCheckpoint, firstTxIdAfterLastCheckPoint, filesNotFound, currentLogVersion, firstLogEntryVersionAfterCheckpoint, null, fallbackKernelVersionProvider);
    }

    public LogTailInformation(CheckpointInfo lastCheckPoint, boolean recordAfterCheckpoint, long firstTxIdAfterLastCheckPoint, boolean filesNotFound, long currentLogVersion, byte firstLogEntryVersionAfterCheckpoint, StoreId storeId, KernelVersionProvider fallbackKernelVersionProvider) {
        this.lastCheckPoint = lastCheckPoint;
        this.firstTxIdAfterLastCheckPoint = firstTxIdAfterLastCheckPoint;
        this.filesNotFound = filesNotFound;
        this.currentLogVersion = currentLogVersion;
        this.firstLogEntryVersionAfterCheckpoint = firstLogEntryVersionAfterCheckpoint;
        this.recordAfterCheckpoint = recordAfterCheckpoint;
        this.storeId = storeId;
        this.fallbackKernelVersionProvider = fallbackKernelVersionProvider;
    }

    public boolean logsAfterLastCheckpoint() {
        return this.recordAfterCheckpoint;
    }

    public boolean logsMissing() {
        return this.lastCheckPoint == null && this.filesNotFound;
    }

    public boolean hasUnreadableBytesInCheckpointLogs() {
        return this.lastCheckPoint != null && !this.lastCheckPoint.channelPositionAfterCheckpoint().equals((Object)this.lastCheckPoint.checkpointFilePostReadPosition());
    }

    public boolean isRecoveryRequired() {
        return this.recordAfterCheckpoint || this.logsMissing() || this.hasUnreadableBytesInCheckpointLogs();
    }

    public Optional<StoreId> getStoreId() {
        return Optional.ofNullable(this.storeId);
    }

    public Optional<CheckpointInfo> getLastCheckPoint() {
        return Optional.ofNullable(this.lastCheckPoint);
    }

    public String toString() {
        return "LogTailInformation{lastCheckPoint=" + this.lastCheckPoint + ", firstTxIdAfterLastCheckPoint=" + this.firstTxIdAfterLastCheckPoint + ", filesNotFound=" + this.filesNotFound + ", currentLogVersion=" + this.currentLogVersion + ", firstLogEntryVersionAfterCheckpoint=" + this.firstLogEntryVersionAfterCheckpoint + ", recordAfterCheckpoint=" + this.recordAfterCheckpoint + "}";
    }

    public long getCheckpointLogVersion() {
        if (this.lastCheckPoint == null) {
            return LogTailLogVersionsMetadata.EMPTY_LOG_TAIL.getCheckpointLogVersion();
        }
        return this.lastCheckPoint.channelPositionAfterCheckpoint().getLogVersion();
    }

    public KernelVersion kernelVersion() {
        if (this.lastCheckPoint != null) {
            return this.lastCheckPoint.kernelVersion();
        }
        if (this.firstLogEntryVersionAfterCheckpoint != 0) {
            return KernelVersion.getForVersion((byte)this.firstLogEntryVersionAfterCheckpoint);
        }
        return this.fallbackKernelVersionProvider.kernelVersion();
    }

    public long getLogVersion() {
        return this.filesNotFound ? LogTailLogVersionsMetadata.EMPTY_LOG_TAIL.getLogVersion() : this.currentLogVersion;
    }

    public TransactionId getLastCommittedTransaction() {
        if (this.lastCheckPoint == null) {
            return LogTailLogVersionsMetadata.EMPTY_LOG_TAIL.getLastCommittedTransaction();
        }
        return this.lastCheckPoint.transactionId();
    }

    public LogPosition getLastTransactionLogPosition() {
        if (this.lastCheckPoint == null) {
            return LogTailLogVersionsMetadata.EMPTY_LOG_TAIL.getLastTransactionLogPosition();
        }
        return this.lastCheckPoint.transactionLogPosition();
    }
}

