/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import java.util.OptionalLong;
import java.util.function.Function;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.exceptions.KernelException;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.internal.schema.constraints.ExistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.internal.schema.constraints.PropertyTypeSet;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.impl.newapi.ReadOnlyTokenRead;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.recovery.LogTailExtractor;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.migration.SchemaRuleMigrationAccessExtended;
import org.neo4j.token.TokenHolders;

public class SchemaMigrator {
    private SchemaMigrator() {
    }

    public static void migrateSchemaRules(StorageEngineFactory fromStorage, StorageEngineFactory toStorage, FileSystemAbstraction fs, PageCache pageCache, PageCacheTracer pageCacheTracer, Config config, DatabaseLayout from, DatabaseLayout toLayout, CursorContextFactory contextFactory) throws IOException, KernelException {
        LogTailExtractor logTailExtractor = new LogTailExtractor(fs, pageCache, config, toStorage, DatabaseTracers.EMPTY);
        LogTailMetadata logTail = logTailExtractor.getTailMetadata(toLayout, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        TokenHolders tokenHolders = fromStorage.loadReadOnlyTokens(fs, from, config, pageCache, pageCacheTracer, true, contextFactory);
        try (SchemaRuleMigrationAccessExtended schemaRuleMigrationAccess = toStorage.schemaRuleMigrationAccess(fs, pageCache, pageCacheTracer, config, toLayout, contextFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE, logTail);){
            ReadOnlyTokenRead tokenRead = new ReadOnlyTokenRead(tokenHolders);
            LongObjectHashMap indexesToConnect = new LongObjectHashMap();
            LongObjectHashMap constraintsToConnect = new LongObjectHashMap();
            for (SchemaRule schemaRule : fromStorage.loadSchemaRules(fs, pageCache, pageCacheTracer, config, from, true, Function.identity(), contextFactory)) {
                SchemaDescriptor schema;
                if (schemaRule instanceof IndexDescriptor) {
                    IndexDescriptor indexDescriptor = (IndexDescriptor)schemaRule;
                    if (indexDescriptor.isTokenIndex()) continue;
                    schema = SchemaMigrator.translateToNewSchema(indexDescriptor.schema(), tokenRead, schemaRuleMigrationAccess.tokenHolders());
                    IndexPrototype newPrototype = indexDescriptor.isUnique() ? IndexPrototype.uniqueForSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)indexDescriptor.getIndexProvider()) : IndexPrototype.forSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)indexDescriptor.getIndexProvider());
                    newPrototype = newPrototype.withName(indexDescriptor.getName()).withIndexType(indexDescriptor.getIndexType()).withIndexConfig(indexDescriptor.getIndexConfig());
                    if (indexDescriptor.isUnique()) {
                        indexesToConnect.put(indexDescriptor.getId(), (Object)new IndexToConnect(indexDescriptor.getId(), indexDescriptor.getOwningConstraintId(), newPrototype));
                        continue;
                    }
                    IndexDescriptor newDescriptor = newPrototype.materialise(schemaRuleMigrationAccess.nextId());
                    schemaRuleMigrationAccess.writeSchemaRule((SchemaRule)newDescriptor);
                    continue;
                }
                if (!(schemaRule instanceof ConstraintDescriptor)) continue;
                ConstraintDescriptor constraintDescriptor = (ConstraintDescriptor)schemaRule;
                schema = SchemaMigrator.translateToNewSchema(constraintDescriptor.schema(), tokenRead, schemaRuleMigrationAccess.tokenHolders());
                ExistenceConstraintDescriptor descriptor = switch (constraintDescriptor.type()) {
                    default -> throw new IncompatibleClassChangeError();
                    case ConstraintType.UNIQUE -> {
                        IndexBackedConstraintDescriptor indexBacked = constraintDescriptor.asIndexBackedConstraint();
                        yield ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)schema, (IndexType)indexBacked.indexType());
                    }
                    case ConstraintType.EXISTS -> ConstraintDescriptorFactory.existsForSchema((SchemaDescriptor)schema);
                    case ConstraintType.UNIQUE_EXISTS -> {
                        IndexBackedConstraintDescriptor indexBacked = constraintDescriptor.asIndexBackedConstraint();
                        yield ConstraintDescriptorFactory.keyForSchema((SchemaDescriptor)schema, (IndexType)indexBacked.indexType());
                    }
                    case ConstraintType.PROPERTY_TYPE -> ConstraintDescriptorFactory.typeForSchema((SchemaDescriptor)schema, (PropertyTypeSet)constraintDescriptor.asPropertyTypeConstraint().propertyType());
                };
                descriptor = descriptor.withName(constraintDescriptor.getName());
                if (descriptor.isIndexBackedConstraint()) {
                    constraintsToConnect.put(constraintDescriptor.getId(), (Object)new ConstraintToConnect(constraintDescriptor.getId(), constraintDescriptor.asIndexBackedConstraint().ownedIndexId(), (ConstraintDescriptor)descriptor));
                    continue;
                }
                descriptor = descriptor.withId(schemaRuleMigrationAccess.nextId());
                schemaRuleMigrationAccess.writeSchemaRule((SchemaRule)descriptor);
            }
            for (ConstraintToConnect constraintToConnect : constraintsToConnect.values()) {
                IndexToConnect indexToConnect = (IndexToConnect)indexesToConnect.remove(constraintToConnect.indexId);
                if (indexToConnect == null || indexToConnect.oldConstraintId.isPresent() && indexToConnect.oldConstraintId.getAsLong() != constraintToConnect.oldId) {
                    throw new UnderlyingStorageException("Encountered an inconsistent schema store - can not migrate. Affected rules have id " + constraintToConnect.oldId + (String)(indexToConnect != null ? " and " + indexToConnect.oldId : ""));
                }
                long newIndexId = schemaRuleMigrationAccess.nextId();
                long newConstraintId = schemaRuleMigrationAccess.nextId();
                schemaRuleMigrationAccess.writeSchemaRule((SchemaRule)indexToConnect.prototype.materialise(newIndexId).withOwningConstraintId(newConstraintId));
                schemaRuleMigrationAccess.writeSchemaRule((SchemaRule)constraintToConnect.prototype.withId(newConstraintId).withOwnedIndexId(newIndexId));
            }
            for (IndexToConnect indexToConnect : indexesToConnect) {
                schemaRuleMigrationAccess.writeSchemaRule((SchemaRule)indexToConnect.prototype.materialise(schemaRuleMigrationAccess.nextId()));
            }
        }
    }

    private static SchemaDescriptor translateToNewSchema(SchemaDescriptor schema, TokenRead tokenRead, TokenHolders dstTokenHolders) throws KernelException {
        int[] propertyIds = schema.getPropertyIds();
        int[] newPropertyIds = new int[propertyIds.length];
        for (int i = 0; i < propertyIds.length; ++i) {
            newPropertyIds[i] = dstTokenHolders.propertyKeyTokens().getOrCreateId(tokenRead.propertyKeyName(propertyIds[i]));
        }
        boolean forNodes = EntityType.NODE.equals((Object)schema.entityType());
        if (schema.isFulltextSchemaDescriptor()) {
            int[] entityTokenIds = schema.getEntityTokenIds();
            int[] newEntityTokenIds = new int[entityTokenIds.length];
            for (int i = 0; i < entityTokenIds.length; ++i) {
                newEntityTokenIds[i] = forNodes ? dstTokenHolders.labelTokens().getOrCreateId(tokenRead.nodeLabelName(entityTokenIds[i])) : dstTokenHolders.relationshipTypeTokens().getOrCreateId(tokenRead.relationshipTypeName(entityTokenIds[i]));
            }
            return SchemaDescriptors.fulltext((EntityType)schema.entityType(), (int[])newEntityTokenIds, (int[])newPropertyIds);
        }
        if (forNodes) {
            return SchemaDescriptors.forLabel((int)dstTokenHolders.labelTokens().getOrCreateId(tokenRead.nodeLabelName(schema.getLabelId())), (int[])newPropertyIds);
        }
        return SchemaDescriptors.forRelType((int)dstTokenHolders.relationshipTypeTokens().getOrCreateId(tokenRead.relationshipTypeName(schema.getRelTypeId())), (int[])newPropertyIds);
    }

    record IndexToConnect(long oldId, OptionalLong oldConstraintId, IndexPrototype prototype) {
    }

    record ConstraintToConnect(long oldId, long indexId, ConstraintDescriptor prototype) {
    }
}

