/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.internal.kernel.api.DefaultCloseListenable;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.TraceableCursor;
import org.neo4j.util.VisibleForTesting;

@VisibleForTesting
public abstract class TraceableCursorImpl<CURSOR>
extends DefaultCloseListenable
implements TraceableCursor {
    private final CursorPool<CURSOR> pool;
    protected KernelReadTracer tracer;
    private boolean returnedToPool;

    TraceableCursorImpl(CursorPool<CURSOR> pool) {
        this.pool = pool;
    }

    public void setTracer(KernelReadTracer tracer) {
        this.tracer = tracer;
    }

    public void removeTracer() {
        this.tracer = null;
    }

    @Override
    public void acquire() {
        if (!this.returnedToPool) {
            throw new IllegalStateException(this + " hasn't been returned to pool yet");
        }
        this.returnedToPool = false;
    }

    public void closeInternal() {
        if (!this.returnedToPool) {
            this.pool.accept(this);
            this.returnedToPool = true;
        }
    }

    @Override
    @VisibleForTesting
    public boolean returnedToPool() {
        return this.returnedToPool;
    }
}

