/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.Objects;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.graphdb.schema.PropertyType;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;

public abstract class PropertyConstraintDefinition
implements ConstraintDefinition {
    protected final InternalSchemaActions actions;
    protected ConstraintDescriptor constraint;

    PropertyConstraintDefinition(InternalSchemaActions actions, ConstraintDescriptor constraint) {
        this.actions = Objects.requireNonNull(actions);
        this.constraint = Objects.requireNonNull(constraint);
    }

    public ConstraintDescriptor getConstraintReference() {
        return this.constraint;
    }

    public abstract Iterable<String> getPropertyKeys();

    public boolean isConstraintType(ConstraintType type) {
        this.assertInUnterminatedTransaction();
        return this.getConstraintType().equals((Object)type);
    }

    public String getName() {
        return this.constraint.getName();
    }

    public void drop() {
        this.assertInUnterminatedTransaction();
        this.actions.dropConstraint(this.constraint);
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    protected void assertInUnterminatedTransaction() {
        this.actions.assertInOpenTransaction();
    }

    public PropertyType[] getPropertyType() {
        this.assertInUnterminatedTransaction();
        throw new IllegalStateException("Constraint is not a property type constraint.");
    }
}

