/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.List;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.dbms.database.ComponentVersion;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;

public enum DbmsRuntimeVersion implements ComponentVersion,
KernelVersionProvider
{
    V4_2(2, DBMS_RUNTIME_COMPONENT, "Neo4j 4.2.0", KernelVersion.V4_2),
    V4_3(3, DBMS_RUNTIME_COMPONENT, "Neo4j 4.3.0-Drop02", KernelVersion.V4_2),
    V4_3_D4(4, DBMS_RUNTIME_COMPONENT, "Neo4j 4.3.0-Drop04", KernelVersion.V4_3_D4),
    V4_4(5, DBMS_RUNTIME_COMPONENT, "Neo4j 4.4", KernelVersion.V4_4),
    V5_0(6, DBMS_RUNTIME_COMPONENT, "Neo4j 5.0", KernelVersion.V5_0),
    V5_7(7, DBMS_RUNTIME_COMPONENT, "Neo4j 5.7", KernelVersion.V5_7),
    V5_8(8, DBMS_RUNTIME_COMPONENT, "Neo4j 5.8", KernelVersion.V5_8),
    V5_9(9, DBMS_RUNTIME_COMPONENT, "Neo4j 5.9", KernelVersion.V5_9),
    V5_10(10, DBMS_RUNTIME_COMPONENT, "Neo4j 5.10", KernelVersion.V5_10),
    V5_11(11, DBMS_RUNTIME_COMPONENT, "Neo4j 5.11", KernelVersion.V5_11),
    V5_12(12, DBMS_RUNTIME_COMPONENT, "Neo4j 5.12", KernelVersion.V5_12),
    V5_13(13, DBMS_RUNTIME_COMPONENT, "Neo4j 5.13", KernelVersion.V5_13),
    GLORIOUS_FUTURE(Integer.MAX_VALUE, DBMS_RUNTIME_COMPONENT, "Future version", KernelVersion.GLORIOUS_FUTURE);

    public static final List<DbmsRuntimeVersion> VERSIONS;
    private static final DbmsRuntimeVersion LATEST_DBMS_RUNTIME_COMPONENT_VERSION;
    private final SystemGraphComponent.Name componentName;
    private final String description;
    private final KernelVersion kernelVersion;
    private final int version;

    public static DbmsRuntimeVersion getLatestVersion(Config config) {
        Integer version = (Integer)config.get(GraphDatabaseInternalSettings.latest_runtime_version);
        return version != null ? DbmsRuntimeVersion.fromVersionNumber(version) : LATEST_DBMS_RUNTIME_COMPONENT_VERSION;
    }

    private DbmsRuntimeVersion(int version, SystemGraphComponent.Name componentName, String description, KernelVersion kernelVersion) {
        this.version = version;
        this.componentName = componentName;
        this.description = description;
        this.kernelVersion = kernelVersion;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public SystemGraphComponent.Name getComponentName() {
        return this.componentName;
    }

    @Override
    public boolean isCurrent(Config config) {
        return this.version == DbmsRuntimeVersion.getLatestVersion((Config)config).version;
    }

    @Override
    public boolean migrationSupported() {
        return true;
    }

    @Override
    public boolean runtimeSupported() {
        return true;
    }

    public static DbmsRuntimeVersion fromVersionNumber(int versionNumber) {
        for (DbmsRuntimeVersion componentVersion : VERSIONS) {
            if (componentVersion.version != versionNumber) continue;
            return componentVersion;
        }
        throw new IllegalArgumentException("Unrecognised DBMS runtime version number: " + versionNumber);
    }

    @Override
    public boolean isGreaterThan(ComponentVersion other) {
        if (!(other instanceof DbmsRuntimeVersion)) {
            throw new IllegalArgumentException("Comparison to different Version type");
        }
        return this.getVersion() > other.getVersion();
    }

    public KernelVersion kernelVersion() {
        return this.kernelVersion;
    }

    static {
        VERSIONS = List.of(DbmsRuntimeVersion.values());
        LATEST_DBMS_RUNTIME_COMPONENT_VERSION = V5_13;
    }
}

