/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.internal.helpers.Args;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FlushableChannel;
import org.neo4j.io.fs.InputStreamReadableChannel;
import org.neo4j.io.fs.OutputStreamWritableChannel;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.index.schema.TokenIndex;
import org.neo4j.kernel.impl.index.schema.TokenScanValue;
import org.neo4j.time.Clocks;
import org.neo4j.time.SystemNanoClock;

public class TokenScanWriteMonitor
implements TokenIndex.WriteMonitor {
    private static final byte TYPE_PREPARE_ADD = 0;
    private static final byte TYPE_PREPARE_REMOVE = 1;
    private static final byte TYPE_MERGE_ADD = 2;
    private static final byte TYPE_MERGE_REMOVE = 3;
    private static final byte TYPE_RANGE = 4;
    private static final byte TYPE_FLUSH = 5;
    private static final byte TYPE_SESSION_END = 6;
    private static final String ARG_TOFILE = "tofile";
    private static final String ARG_TXFILTER = "txfilter";
    private final FileSystemAbstraction fs;
    private final Monitor monitor;
    private final SystemNanoClock clock;
    private final Path storeDir;
    private final Path file;
    private FlushableChannel channel;
    private final Lock lock = new ReentrantLock();
    private final LongAdder position = new LongAdder();
    private final long rotationThreshold;
    private final long pruneThreshold;
    public static final Monitor NO_MONITOR = new Monitor(){

        @Override
        public void rotated(Path file, long timestamp, long size) {
        }

        @Override
        public void pruned(Path file, long timestamp) {
        }
    };

    TokenScanWriteMonitor(FileSystemAbstraction fs, DatabaseLayout databaseLayout, EntityType entityType, Config config) {
        this(fs, databaseLayout, (Long)config.get(GraphDatabaseInternalSettings.token_scan_write_log_rotation_threshold), ByteUnit.Byte, ((Duration)config.get(GraphDatabaseInternalSettings.token_scan_write_log_prune_threshold)).toMillis(), TimeUnit.MILLISECONDS, entityType, NO_MONITOR, Clocks.nanoClock());
    }

    TokenScanWriteMonitor(FileSystemAbstraction fs, DatabaseLayout databaseLayout, long rotationThreshold, ByteUnit rotationThresholdUnit, long pruneThreshold, TimeUnit pruneThresholdUnit, EntityType entityType, Monitor monitor, SystemNanoClock clock) {
        this.fs = fs;
        this.monitor = monitor;
        this.clock = clock;
        this.rotationThreshold = rotationThresholdUnit.toBytes(rotationThreshold);
        this.pruneThreshold = pruneThresholdUnit.toMillis(pruneThreshold);
        this.storeDir = databaseLayout.databaseDirectory();
        this.file = TokenScanWriteMonitor.writeLogBaseFile(databaseLayout, entityType);
        try {
            if (fs.fileExists(this.file)) {
                this.moveAwayFile(fs.getFileSize(this.file));
            }
            this.channel = this.instantiateChannel();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static Path writeLogBaseFile(DatabaseLayout databaseLayout, EntityType entityType) {
        Path baseFile = entityType == EntityType.NODE ? databaseLayout.labelScanStore() : databaseLayout.relationshipTypeScanStore();
        return baseFile.resolveSibling(baseFile.getFileName() + ".writelog");
    }

    private FlushableChannel instantiateChannel() throws IOException {
        return new OutputStreamWritableChannel(this.fs.openAsOutputStream(this.file, false));
    }

    @Override
    public void range(long range, int tokenId) {
        try {
            this.channel.put((byte)4);
            this.channel.putLong(range);
            this.channel.putInt(tokenId);
            this.position.add(13L);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void prepareAdd(long txId, int offset) {
        this.prepare((byte)0, txId, offset);
    }

    @Override
    public void prepareRemove(long txId, int offset) {
        this.prepare((byte)1, txId, offset);
    }

    private void prepare(byte type, long txId, int offset) {
        try {
            this.channel.put(type);
            this.channel.putLong(txId);
            this.channel.put((byte)offset);
            this.position.add(10L);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void mergeAdd(TokenScanValue existingValue, TokenScanValue newValue) {
        this.merge((byte)2, existingValue, newValue);
    }

    @Override
    public void mergeRemove(TokenScanValue existingValue, TokenScanValue newValue) {
        this.merge((byte)3, existingValue, newValue);
    }

    private void merge(byte type, TokenScanValue existingValue, TokenScanValue newValue) {
        try {
            this.channel.put(type);
            this.channel.putLong(existingValue.bits);
            this.channel.putLong(newValue.bits);
            this.position.add(17L);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void flushPendingUpdates() {
        try {
            this.channel.put((byte)5);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void writeSessionEnded() {
        try {
            this.channel.put((byte)6);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.position.add(1L);
        long fileSize = this.position.sum();
        if (fileSize > this.rotationThreshold) {
            this.lock.lock();
            try {
                this.channel.prepareForFlush().flush();
                this.channel.close();
                this.moveAwayFile(fileSize);
                this.position.reset();
                this.channel = this.instantiateChannel();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                this.lock.unlock();
            }
            try {
                long time = this.clock.millis();
                long threshold = time - this.pruneThreshold;
                for (Path file : this.fs.listFiles(this.storeDir, name -> name.getFileName().toString().startsWith(this.file.getFileName() + "-"))) {
                    long timestamp = TokenScanWriteMonitor.millisOf(file);
                    if (timestamp >= threshold) continue;
                    this.fs.deleteFile(file);
                    this.monitor.pruned(file, timestamp);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    static long millisOf(Path file) {
        String name = file.getFileName().toString();
        int dashIndex = name.lastIndexOf(45);
        if (dashIndex == -1) {
            return 0L;
        }
        return Long.parseLong(name.substring(dashIndex + 1));
    }

    @Override
    public void force() {
        this.lock.lock();
        try {
            this.channel.prepareForFlush().flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        try {
            this.channel.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void moveAwayFile(long fileSize) throws IOException {
        Path to;
        while (this.fs.fileExists(to = this.timestampedFile())) {
        }
        this.fs.renameFile(this.file, to, new CopyOption[0]);
        this.monitor.rotated(to, TokenScanWriteMonitor.millisOf(to), fileSize);
    }

    private Path timestampedFile() {
        return this.storeDir.resolve(this.file.getFileName() + "-" + this.clock.millis());
    }

    public static void main(String[] args) throws IOException {
        Args arguments = Args.withFlags((String[])new String[]{ARG_TOFILE}).parse(args);
        if (arguments.orphans().isEmpty()) {
            System.err.println("Please supply database directory");
            return;
        }
        DatabaseLayout databaseLayout = DatabaseLayout.ofFlat((Path)Path.of((String)arguments.orphans().get(0), new String[0]));
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        TxFilter txFilter = TokenScanWriteMonitor.parseTxFilter(arguments.get(ARG_TXFILTER, null));
        PrintStream out = System.out;
        boolean redirectsToFile = arguments.getBoolean(ARG_TOFILE);
        for (EntityType entityType : EntityType.values()) {
            if (redirectsToFile) {
                Path outFile = Path.of(TokenScanWriteMonitor.writeLogBaseFile(databaseLayout, entityType).toAbsolutePath() + ".txt", new String[0]);
                System.out.println("Redirecting output to " + outFile);
                out = new PrintStream(new BufferedOutputStream(Files.newOutputStream(outFile, new OpenOption[0])));
            }
            PrintStreamDumper dumper = new PrintStreamDumper(out);
            TokenScanWriteMonitor.dump((FileSystemAbstraction)fs, databaseLayout, dumper, txFilter, entityType);
            if (!redirectsToFile) continue;
            out.close();
        }
    }

    public static void dump(FileSystemAbstraction fs, DatabaseLayout databaseLayout, Dumper dumper, TxFilter txFilter, EntityType entityType) throws IOException {
        Path writeLogFile = TokenScanWriteMonitor.writeLogBaseFile(databaseLayout, entityType);
        String writeLogFileBaseName = writeLogFile.getFileName().toString();
        Path[] files = fs.listFiles(databaseLayout.databaseDirectory(), name -> name.getFileName().toString().startsWith(writeLogFileBaseName));
        Arrays.sort(files, Comparator.comparing(file -> file.getFileName().toString().equals(writeLogFileBaseName) ? 0L : TokenScanWriteMonitor.millisOf(file)));
        long session = 0L;
        for (Path file2 : files) {
            dumper.file(file2);
            session = TokenScanWriteMonitor.dumpFile(fs, file2, dumper, txFilter, session);
        }
    }

    private static long dumpFile(FileSystemAbstraction fs, Path file, Dumper dumper, TxFilter txFilter, long session) throws IOException {
        try {
            InputStreamReadableChannel channel = new InputStreamReadableChannel(fs.openAsInputStream(file));
            try {
                long range = -1L;
                int tokenId = -1;
                long flush = 0L;
                block13: while (true) {
                    byte type = channel.get();
                    switch (type) {
                        case 4: {
                            range = channel.getLong();
                            tokenId = channel.getInt();
                            if (txFilter == null) continue block13;
                            txFilter.clear();
                            continue block13;
                        }
                        case 0: 
                        case 1: {
                            TokenScanWriteMonitor.dumpPrepare(dumper, type, (ReadableChannel)channel, range, tokenId, txFilter, session, flush);
                            continue block13;
                        }
                        case 2: 
                        case 3: {
                            TokenScanWriteMonitor.dumpMerge(dumper, type, (ReadableChannel)channel, range, tokenId, txFilter, session, flush);
                            continue block13;
                        }
                        case 5: {
                            ++flush;
                            continue block13;
                        }
                        case 6: {
                            ++session;
                            flush = 0L;
                            continue block13;
                        }
                    }
                    System.out.println("Unknown type " + type);
                }
            }
            catch (Throwable throwable) {
                try {
                    channel.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (EOFException eOFException) {
            return session;
        }
    }

    private static void dumpMerge(Dumper dumper, byte type, ReadableChannel channel, long range, int tokenId, TxFilter txFilter, long session, long flush) throws IOException {
        long existingBits = channel.getLong();
        long newBits = channel.getLong();
        if (txFilter == null || txFilter.contains()) {
            dumper.merge(type == 2, session, flush, range, tokenId, existingBits, newBits);
        }
    }

    private static void dumpPrepare(Dumper dumper, byte type, ReadableChannel channel, long range, int tokenId, TxFilter txFilter, long session, long flush) throws IOException {
        long txId = channel.getLong();
        byte offset = channel.get();
        long entityId = range * 64L + (long)offset;
        if (txFilter == null || txFilter.contains(txId)) {
            dumper.prepare(type == 0, session, flush, txId, entityId, tokenId);
        }
    }

    static TxFilter parseTxFilter(String txFilter) {
        if (txFilter == null) {
            return null;
        }
        String[] tokens = txFilter.split(",");
        long[][] filters = new long[tokens.length][];
        for (int i = 0; i < tokens.length; ++i) {
            long low;
            long high;
            String token = tokens[i];
            int index = token.lastIndexOf(45);
            if (index == -1) {
                low = high = Long.parseLong(token);
            } else {
                low = Long.parseLong(token.substring(0, index));
                high = Long.parseLong(token.substring(index + 1));
            }
            filters[i] = new long[]{low, high};
        }
        return new TxFilter(filters);
    }

    public static interface Monitor {
        public void rotated(Path var1, long var2, long var4);

        public void pruned(Path var1, long var2);
    }

    public static class PrintStreamDumper
    implements Dumper {
        private final PrintStream out;
        private final char[] bitsAsChars = new char[71];

        PrintStreamDumper(PrintStream out) {
            this.out = out;
            Arrays.fill(this.bitsAsChars, ' ');
        }

        @Override
        public void file(Path file) {
            this.out.println("=== " + file.toAbsolutePath() + " ===");
        }

        @Override
        public void prepare(boolean add, long session, long flush, long txId, long entityId, int tokenId) {
            this.out.printf("[%d,%d]%stx:%d,entity:%d,token:%d%n", session, flush, Character.valueOf(add ? (char)'+' : '-'), txId, entityId, tokenId);
        }

        @Override
        public void merge(boolean add, long session, long flush, long range, int tokenId, long existingBits, long newBits) {
            this.out.printf("[%d,%d]%srange:%d,tokenId:%d%n [%s]%n [%s]%n", session, flush, Character.valueOf(add ? (char)'+' : '-'), range, tokenId, PrintStreamDumper.bits(existingBits, this.bitsAsChars), PrintStreamDumper.bits(newBits, this.bitsAsChars));
        }

        private static String bits(long bits, char[] bitsAsChars) {
            long mask = 1L;
            int i = 0;
            int c = 0;
            while (i < 64) {
                if (i % 8 == 0) {
                    ++c;
                }
                boolean set = (bits & mask) != 0L;
                bitsAsChars[bitsAsChars.length - c] = set ? 49 : 48;
                mask <<= 1;
                ++i;
                ++c;
            }
            return String.valueOf(bitsAsChars);
        }
    }

    public static interface Dumper {
        public void file(Path var1);

        public void prepare(boolean var1, long var2, long var4, long var6, long var8, int var10);

        public void merge(boolean var1, long var2, long var4, long var6, int var8, long var9, long var11);
    }

    static class TxFilter {
        private final long[][] lowsAndHighs;
        private boolean contains;

        TxFilter(long[] ... lowsAndHighs) {
            this.lowsAndHighs = lowsAndHighs;
        }

        void clear() {
            this.contains = false;
        }

        boolean contains(long txId) {
            for (long[] filter : this.lowsAndHighs) {
                if (txId < filter[0] || txId > filter[1]) continue;
                this.contains = true;
                return true;
            }
            return false;
        }

        boolean contains() {
            return this.contains;
        }
    }
}

