/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.time.Duration;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointThreshold;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointThresholdPolicy;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CountCommittedTransactionThreshold;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TimeCheckPointThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruning;
import org.neo4j.logging.LogProvider;
import org.neo4j.time.SystemNanoClock;

public class PeriodicThresholdPolicy
implements CheckPointThresholdPolicy {
    public String getName() {
        return "periodic";
    }

    @Override
    public CheckPointThreshold createThreshold(Config config, SystemNanoClock clock, LogPruning logPruning, LogProvider logProvider) {
        int txThreshold = (Integer)config.get(GraphDatabaseSettings.check_point_interval_tx);
        CountCommittedTransactionThreshold countCommittedTransactionThreshold = new CountCommittedTransactionThreshold(txThreshold);
        long timeMillisThreshold = ((Duration)config.get(GraphDatabaseSettings.check_point_interval_time)).toMillis();
        TimeCheckPointThreshold timeCheckPointThreshold = new TimeCheckPointThreshold(timeMillisThreshold, clock);
        return CheckPointThreshold.or(countCommittedTransactionThreshold, timeCheckPointThreshold);
    }
}

