/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.storageengine.api.StorageCommand;

public class PhysicalTransactionRepresentation
implements TransactionRepresentation {
    private final List<StorageCommand> commands;
    private byte[] additionalHeader;
    private long timeStarted;
    private long latestCommittedTxWhenStarted;
    private long timeCommitted;
    private AuthSubject subject;
    private int leaseId;

    public PhysicalTransactionRepresentation(List<StorageCommand> commands) {
        this.commands = commands;
    }

    public PhysicalTransactionRepresentation(List<StorageCommand> commands, byte[] additionalHeader, long timeStarted, long latestCommittedTxWhenStarted, long timeCommitted, int leaseId, AuthSubject subject) {
        this(commands);
        this.setHeader(additionalHeader, timeStarted, latestCommittedTxWhenStarted, timeCommitted, leaseId, subject);
    }

    public void setAdditionalHeader(byte[] additionalHeader) {
        this.additionalHeader = additionalHeader;
    }

    public void setHeader(byte[] additionalHeader, long timeStarted, long latestCommittedTxWhenStarted, long timeCommitted, int leaseId, AuthSubject subject) {
        this.additionalHeader = additionalHeader;
        this.timeStarted = timeStarted;
        this.latestCommittedTxWhenStarted = latestCommittedTxWhenStarted;
        this.timeCommitted = timeCommitted;
        this.leaseId = leaseId;
        this.subject = subject;
    }

    public boolean accept(Visitor<StorageCommand, IOException> visitor) throws IOException {
        for (StorageCommand command : this.commands) {
            if (!visitor.visit((Object)command)) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte[] additionalHeader() {
        return this.additionalHeader;
    }

    @Override
    public long getTimeStarted() {
        return this.timeStarted;
    }

    @Override
    public long getLatestCommittedTxWhenStarted() {
        return this.latestCommittedTxWhenStarted;
    }

    @Override
    public long getTimeCommitted() {
        return this.timeCommitted;
    }

    @Override
    public int getLeaseId() {
        return this.leaseId;
    }

    @Override
    public AuthSubject getAuthSubject() {
        return this.subject;
    }

    @Override
    public KernelVersion version() {
        return this.commands.isEmpty() ? null : this.commands.get(0).version();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhysicalTransactionRepresentation that = (PhysicalTransactionRepresentation)o;
        return this.latestCommittedTxWhenStarted == that.latestCommittedTxWhenStarted && this.timeStarted == that.timeStarted && Arrays.equals(this.additionalHeader, that.additionalHeader) && this.commands.equals(that.commands);
    }

    public int hashCode() {
        int result = this.commands.hashCode();
        result = 31 * result + (this.additionalHeader != null ? Arrays.hashCode(this.additionalHeader) : 0);
        result = 31 * result + (int)(this.timeStarted ^ this.timeStarted >>> 32);
        result = 31 * result + (int)(this.latestCommittedTxWhenStarted ^ this.latestCommittedTxWhenStarted >>> 32);
        return result;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean includeCommands) {
        String basic = String.format("%s[timeStarted:%d, latestCommittedTxWhenStarted:%d, timeCommitted:%d, lease:%d, additionalHeader:%s, commands.length:%d", this.getClass().getSimpleName(), this.timeStarted, this.latestCommittedTxWhenStarted, this.timeCommitted, this.leaseId, Arrays.toString(this.additionalHeader), this.commands.size());
        if (!includeCommands) {
            return basic;
        }
        StringBuilder builder = new StringBuilder(basic);
        for (StorageCommand command : this.commands) {
            builder.append(String.format("%n%s", command.toString()));
        }
        return builder.toString();
    }

    public Iterator<StorageCommand> iterator() {
        return this.commands.iterator();
    }

    public int commandCount() {
        return this.commands.size();
    }
}

