/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.monitoring.Monitors;

public class DatabaseIndexContext {
    final PageCache pageCache;
    final FileSystemAbstraction fileSystem;
    final Monitors monitors;
    final String monitorTag;
    final DatabaseReadOnlyChecker readOnlyChecker;
    final PageCacheTracer pageCacheTracer;
    final String databaseName;

    private DatabaseIndexContext(PageCache pageCache, FileSystemAbstraction fileSystem, Monitors monitors, String monitorTag, DatabaseReadOnlyChecker readOnlyChecker, PageCacheTracer pageCacheTracer, String databaseName) {
        this.pageCache = pageCache;
        this.fileSystem = fileSystem;
        this.monitors = monitors;
        this.monitorTag = monitorTag;
        this.readOnlyChecker = readOnlyChecker;
        this.pageCacheTracer = pageCacheTracer;
        this.databaseName = databaseName;
    }

    public static Builder builder(PageCache pageCache, FileSystemAbstraction fileSystem, String databaseName) {
        return new Builder(pageCache, fileSystem, databaseName);
    }

    public static Builder builder(DatabaseIndexContext copy) {
        return new Builder(copy.pageCache, copy.fileSystem, copy.databaseName).withReadOnlyChecker(copy.readOnlyChecker).withMonitors(copy.monitors).withTag(copy.monitorTag).withPageCacheTracer(copy.pageCacheTracer);
    }

    public static class Builder {
        private final PageCache pageCache;
        private final FileSystemAbstraction fileSystem;
        private final String databaseName;
        private Monitors monitors;
        private String monitorTag;
        private DatabaseReadOnlyChecker readOnlyChecker;
        private PageCacheTracer pageCacheTracer;

        private Builder(PageCache pageCache, FileSystemAbstraction fileSystem, String databaseName) {
            this.pageCache = pageCache;
            this.fileSystem = fileSystem;
            this.databaseName = databaseName;
            this.monitors = new Monitors();
            this.monitorTag = "";
            this.readOnlyChecker = DatabaseReadOnlyChecker.writable();
            this.pageCacheTracer = PageCacheTracer.NULL;
        }

        public Builder withReadOnlyChecker(DatabaseReadOnlyChecker readOnlyChecker) {
            this.readOnlyChecker = readOnlyChecker;
            return this;
        }

        public Builder withMonitors(Monitors monitors) {
            this.monitors = monitors;
            return this;
        }

        public Builder withTag(String monitorTag) {
            this.monitorTag = monitorTag;
            return this;
        }

        public Builder withPageCacheTracer(PageCacheTracer tracer) {
            this.pageCacheTracer = tracer;
            return this;
        }

        public DatabaseIndexContext build() {
            return new DatabaseIndexContext(this.pageCache, this.fileSystem, this.monitors, this.monitorTag, this.readOnlyChecker, this.pageCacheTracer, this.databaseName);
        }
    }
}

