/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.kernel.impl.index.schema.AbstractArrayType;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GeometryArrayType;
import org.neo4j.kernel.impl.index.schema.GeometryType;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.Type;
import org.neo4j.kernel.impl.index.schema.Types;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.CoordinateReferenceSystem;

public class BtreeKey
extends GenericKey<BtreeKey> {
    private final IndexSpecificSpaceFillingCurveSettings settings;

    BtreeKey(IndexSpecificSpaceFillingCurveSettings settings) {
        this.settings = settings;
    }

    public void writePoint(CoordinateReferenceSystem crs, double[] coordinate) {
        if (!this.isArray) {
            this.setType(Types.GEOMETRY);
            this.updateCurve(crs.getTable().getTableId(), crs.getCode());
            GeometryType.write(this, this.spaceFillingCurve.derivedValueFor(coordinate), coordinate);
        } else {
            if (this.currentArrayOffset == 0) {
                this.updateCurve(crs.getTable().getTableId(), crs.getCode());
            } else if (this.long1 != (long)crs.getTable().getTableId() || this.long2 != (long)crs.getCode()) {
                throw new IllegalStateException(String.format("Tried to assign a geometry array containing different coordinate reference systems, first:%s, violating:%s at array position:%d", CoordinateReferenceSystem.get((int)((int)this.long1), (int)((int)this.long2)), crs, this.currentArrayOffset));
            }
            GeometryArrayType.write(this, this.currentArrayOffset++, this.spaceFillingCurve.derivedValueFor(coordinate), coordinate);
        }
    }

    void writePointDerived(CoordinateReferenceSystem crs, long derivedValue, NativeIndexKey.Inclusion inclusion) {
        if (this.isArray) {
            throw new IllegalStateException("This method is intended to be called when querying, where one or more sub-ranges are derived from a queried range and each sub-range written to separate keys. As such it's unexpected that this key state thinks that it's holds state for an array");
        }
        this.setType(Types.GEOMETRY);
        this.updateCurve(crs.getTable().getTableId(), crs.getCode());
        GeometryType.write(this, derivedValue, NO_COORDINATES);
        this.inclusion = inclusion;
    }

    private void updateCurve(int tableId, int code) {
        if (this.long1 != (long)tableId || this.long2 != (long)code) {
            this.long1 = tableId;
            this.long2 = code;
            this.spaceFillingCurve = this.settings.forCrs(tableId, code);
        }
    }

    @Override
    BtreeKey stateSlot(int slot) {
        Preconditions.checkState((slot == 0 ? 1 : 0) != 0, (String)"BtreeKey only supports a single key slot");
        return this;
    }

    @Override
    Type[] getTypesById() {
        return Types.Btree.BY_ID;
    }

    @Override
    AbstractArrayType<?>[] getArrayTypes() {
        return Types.Btree.BY_ARRAY_TYPE;
    }

    @Override
    Type getLowestByValueGroup() {
        return Types.Btree.LOWEST_BY_VALUE_GROUP;
    }

    @Override
    Type getHighestByValueGroup() {
        return Types.Btree.HIGHEST_BY_VALUE_GROUP;
    }

    @Override
    Type[] getTypesByGroup() {
        return Types.Btree.BY_GROUP;
    }
}

