/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.internal;

import java.util.Arrays;
import org.neo4j.graphdb.Entity;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.impl.coreapi.internal.CursorEntityFactory;
import org.neo4j.kernel.impl.coreapi.internal.PrefetchingEntityResourceIterator;
import org.neo4j.kernel.impl.newapi.CursorPredicates;
import org.neo4j.storageengine.api.PropertySelection;

public abstract class PropertyFilteringIterator<T extends Entity, TOKEN_CURSOR extends Cursor, ENTITY_CURSOR extends Cursor>
extends PrefetchingEntityResourceIterator<TOKEN_CURSOR, T> {
    private final TOKEN_CURSOR entityTokenCursor;
    private final ENTITY_CURSOR entityCursor;
    private final PropertyCursor propertyCursor;
    private final PropertyIndexQuery[] queries;
    private final ResourceTracker resourceTracker;
    private final PropertySelection propertySelection;

    protected PropertyFilteringIterator(TOKEN_CURSOR entityTokenCursor, ENTITY_CURSOR entityCursor, PropertyCursor propertyCursor, CursorEntityFactory<TOKEN_CURSOR, T> entityFactory, ResourceTracker resourceTracker, PropertyIndexQuery[] queries) {
        super(entityTokenCursor, entityFactory);
        this.entityTokenCursor = entityTokenCursor;
        this.entityCursor = entityCursor;
        this.propertyCursor = propertyCursor;
        this.queries = queries;
        this.resourceTracker = resourceTracker;
        resourceTracker.registerCloseableResource((AutoCloseable)((Object)this));
        this.propertySelection = PropertySelection.selection((int[])Arrays.stream(queries).mapToInt(PropertyIndexQuery::propertyKeyId).toArray());
    }

    @Override
    protected long fetchNext() {
        boolean hasNext;
        while ((hasNext = this.entityTokenCursor.next()) && !this.hasPropertiesWithValues()) {
        }
        if (hasNext) {
            return this.entityReference(this.entityTokenCursor);
        }
        return -1L;
    }

    @Override
    void closeResources() {
        IOUtils.closeAllSilently((AutoCloseable[])new Cursor[]{this.entityTokenCursor, this.entityCursor, this.propertyCursor});
        this.resourceTracker.unregisterCloseableResource((AutoCloseable)((Object)this));
    }

    private boolean hasPropertiesWithValues() {
        this.singleEntity(this.entityReference(this.entityTokenCursor), this.entityCursor);
        if (this.entityCursor.next()) {
            this.properties(this.entityCursor, this.propertyCursor, this.propertySelection);
            return CursorPredicates.propertiesMatch(this.propertyCursor, this.queries);
        }
        return false;
    }

    protected abstract long entityReference(TOKEN_CURSOR var1);

    protected abstract void singleEntity(long var1, ENTITY_CURSOR var3);

    protected abstract void properties(ENTITY_CURSOR var1, PropertyCursor var2, PropertySelection var3);
}

