/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.diagnostics;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.neo4j.configuration.Config;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.diagnostics.DiagnosticsOfflineReportProvider;
import org.neo4j.kernel.diagnostics.DiagnosticsReportSource;
import org.neo4j.kernel.diagnostics.DiagnosticsReporterProgress;
import org.neo4j.kernel.diagnostics.ProgressAwareInputStream;
import org.neo4j.service.Services;

public class DiagnosticsReporter {
    private final List<DiagnosticsOfflineReportProvider> providers = new ArrayList<DiagnosticsOfflineReportProvider>();
    private final Set<String> availableClassifiers = new TreeSet<String>();
    private final Map<String, List<DiagnosticsReportSource>> additionalSources = new HashMap<String, List<DiagnosticsReportSource>>();

    public void registerOfflineProvider(DiagnosticsOfflineReportProvider provider) {
        this.providers.add(provider);
        this.availableClassifiers.addAll(provider.getFilterClassifiers());
    }

    public void registerSource(String classifier, DiagnosticsReportSource source) {
        this.availableClassifiers.add(classifier);
        this.additionalSources.computeIfAbsent(classifier, c -> new ArrayList()).add(source);
    }

    public void dump(Set<String> classifiers, Path destination, DiagnosticsReporterProgress progress, boolean force) throws IOException {
        List<DiagnosticsReportSource> sources = this.getAllSources(classifiers);
        Path destinationDir = Files.createDirectories(destination.getParent(), new FileAttribute[0]);
        if (!force) {
            DiagnosticsReporter.estimateSizeAndCheckAvailableDiskSpace(destination, sources, destinationDir);
        }
        progress.setTotalSteps(sources.size());
        try (ZipOutputStream zip = new ZipOutputStream((OutputStream)new BufferedOutputStream(Files.newOutputStream(destination, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE)), StandardCharsets.UTF_8);){
            DiagnosticsReporter.writeDiagnostics(zip, sources, progress);
        }
    }

    private static void writeDiagnostics(ZipOutputStream zip, List<DiagnosticsReportSource> sources, DiagnosticsReporterProgress progress) {
        int step = 0;
        byte[] buf = new byte[(int)ByteUnit.kibiBytes((long)8L)];
        for (DiagnosticsReportSource source : sources) {
            progress.started(++step, source.destinationPath());
            try (InputStream rawInput = source.newInputStream();
                 ProgressAwareInputStream input = new ProgressAwareInputStream(new BufferedInputStream(rawInput), source.estimatedSize(), progress::percentChanged);){
                int chunkSize;
                ZipEntry entry = new ZipEntry(source.destinationPath());
                zip.putNextEntry(entry);
                while ((chunkSize = ((InputStream)input).read(buf)) >= 0) {
                    zip.write(buf, 0, chunkSize);
                }
                zip.closeEntry();
            }
            catch (Exception e) {
                progress.error("Failed to write " + source.destinationPath(), e);
                continue;
            }
            progress.finished();
        }
    }

    private List<DiagnosticsReportSource> getAllSources(Set<String> classifiers) {
        ArrayList<DiagnosticsReportSource> allSources = new ArrayList<DiagnosticsReportSource>();
        this.providers.forEach(provider -> allSources.addAll(provider.getDiagnosticsSources(classifiers)));
        this.additionalSources.forEach((classifier, sources) -> {
            if (classifiers.contains("all") || classifiers.contains(classifier)) {
                allSources.addAll((Collection<DiagnosticsReportSource>)sources);
            }
        });
        return allSources;
    }

    private static void estimateSizeAndCheckAvailableDiskSpace(Path destination, List<DiagnosticsReportSource> sources, Path destinationDir) {
        long freeSpace;
        long estimatedFinalSize = sources.stream().mapToLong(DiagnosticsReportSource::estimatedSize).sum();
        if (estimatedFinalSize > (freeSpace = destinationDir.toFile().getFreeSpace())) {
            throw new RuntimeException(String.format("Free available disk space for %s is %s, worst case estimate is %s. To ignore add '--force' to the command.", destination.getFileName(), ByteUnit.bytesToString((long)freeSpace), ByteUnit.bytesToString((long)estimatedFinalSize)));
        }
    }

    public Set<String> getAvailableClassifiers() {
        return this.availableClassifiers;
    }

    public void registerAllOfflineProviders(Config config, Path storeDirectory, FileSystemAbstraction fs, String defaultDatabaseName) {
        for (DiagnosticsOfflineReportProvider provider : Services.loadAll(DiagnosticsOfflineReportProvider.class)) {
            provider.init(fs, defaultDatabaseName, config, storeDirectory);
            this.registerOfflineProvider(provider);
        }
    }
}

