/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.dbms.database.DbmsRuntimeRepository;
import org.neo4j.dbms.database.DbmsRuntimeSystemGraphComponent;
import org.neo4j.dbms.database.DbmsRuntimeVersion;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.internal.helpers.collection.Iterables;

public class StandaloneDbmsRuntimeRepository
extends DbmsRuntimeRepository
implements TransactionEventListener<Object> {
    public StandaloneDbmsRuntimeRepository(DatabaseManager<?> databaseManager, DbmsRuntimeSystemGraphComponent component) {
        super(databaseManager, component);
    }

    public Object beforeCommit(TransactionData data, Transaction transaction, GraphDatabaseService databaseService) throws Exception {
        return null;
    }

    public void afterCommit(TransactionData transactionData, Object state, GraphDatabaseService databaseService) {
        if (transactionData == null || this.getVersion().isCurrent()) {
            return;
        }
        List nodesWithChangedProperties = Iterables.stream((Iterable)transactionData.assignedNodeProperties()).map(nodePropertyEntry -> ((Node)nodePropertyEntry.entity()).getId()).collect(Collectors.toList());
        GraphDatabaseService systemDatabase = this.getSystemDb();
        try (Transaction tx = systemDatabase.beginTx();){
            nodesWithChangedProperties.stream().map(arg_0 -> ((Transaction)tx).getNodeById(arg_0)).filter(node -> node.hasLabel(SystemGraphComponent.VERSION_LABEL) && node.hasProperty(this.component.componentName())).map(dbmRuntime -> (int)((Integer)dbmRuntime.getProperty(this.component.componentName()))).map(DbmsRuntimeVersion::fromVersionNumber).forEach(this::setVersion);
        }
    }

    public void afterRollback(TransactionData data, Object state, GraphDatabaseService databaseService) {
    }
}

