/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.internal.kernel.api.NamedToken;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.PageCacheAndDependenciesRule;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;

public class BatchingTokenRepositoryTest {
    @Rule
    public final PageCacheAndDependenciesRule storage = new PageCacheAndDependenciesRule();

    @Test
    public void shouldDedupLabelIds() {
        BatchingTokenRepository.BatchingLabelTokenRepository repo = new BatchingTokenRepository.BatchingLabelTokenRepository((TokenStore)Mockito.mock(TokenStore.class));
        long[] ids = repo.getOrCreateIds(new String[]{"One", "Two", "One"});
        Assert.assertTrue((boolean)NodeLabelsField.isSane((long[])ids));
    }

    @Test
    public void shouldSortLabelIds() {
        BatchingTokenRepository.BatchingLabelTokenRepository repo = new BatchingTokenRepository.BatchingLabelTokenRepository((TokenStore)Mockito.mock(TokenStore.class));
        long[] expected = new long[]{repo.getOrCreateId("One"), repo.getOrCreateId("Two"), repo.getOrCreateId("Three")};
        long[] ids = repo.getOrCreateIds(new String[]{"Two", "One", "Three"});
        Assert.assertArrayEquals((long[])expected, (long[])ids);
        Assert.assertTrue((boolean)NodeLabelsField.isSane((long[])ids));
    }

    @Test
    public void shouldRespectExistingTokens() {
        TokenStore tokenStore = (TokenStore)Mockito.mock(TokenStore.class);
        int previousHighId = 5;
        Mockito.when((Object)tokenStore.getHighId()).thenReturn((Object)previousHighId);
        BatchingTokenRepository.BatchingRelationshipTypeTokenRepository repo = new BatchingTokenRepository.BatchingRelationshipTypeTokenRepository(tokenStore);
        ((TokenStore)Mockito.verify((Object)tokenStore)).getHighId();
        int tokenId = repo.getOrCreateId("NEW_ONE");
        Assert.assertEquals((long)previousHighId, (long)tokenId);
    }

    @Test
    public void shouldFlushNewTokens() {
        try (PageCache pageCache = this.storage.pageCache();
             NeoStores stores = new StoreFactory(this.storage.directory().databaseLayout(), Config.defaults(), (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.storage.fileSystem()), pageCache, this.storage.fileSystem(), (LogProvider)NullLogProvider.getInstance(), EmptyVersionContextSupplier.EMPTY).openNeoStores(true, new StoreType[]{StoreType.PROPERTY_KEY_TOKEN, StoreType.PROPERTY_KEY_TOKEN_NAME});){
            PropertyKeyTokenStore tokenStore = stores.getPropertyKeyTokenStore();
            int rounds = 3;
            int tokensPerRound = 4;
            BatchingTokenRepository.BatchingPropertyKeyTokenRepository repo = new BatchingTokenRepository.BatchingPropertyKeyTokenRepository((TokenStore)tokenStore);
            Object object = null;
            try {
                int expectedId = 0;
                int tokenNameAsInt = 0;
                for (int round = 0; round < rounds; ++round) {
                    for (int i = 0; i < tokensPerRound; ++i) {
                        int tokenId = repo.getOrCreateId(String.valueOf(tokenNameAsInt++));
                        Assert.assertEquals((long)(expectedId + i), (long)tokenId);
                    }
                    Assert.assertEquals((long)expectedId, (long)tokenStore.getHighId());
                    repo.flush();
                    Assert.assertEquals((long)(expectedId + tokensPerRound), (long)tokenStore.getHighId());
                    expectedId += tokensPerRound;
                }
            }
            catch (Throwable expectedId) {
                object = expectedId;
                throw expectedId;
            }
            finally {
                if (repo != null) {
                    if (object != null) {
                        try {
                            repo.close();
                        }
                        catch (Throwable expectedId) {
                            ((Throwable)object).addSuppressed(expectedId);
                        }
                    } else {
                        repo.close();
                    }
                }
            }
            List tokens = tokenStore.getTokens();
            Assert.assertEquals((long)(tokensPerRound * rounds), (long)tokens.size());
            for (NamedToken token : tokens) {
                Assert.assertEquals((long)token.id(), (long)Integer.parseInt(token.name()));
            }
        }
    }
}

