/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalFlushableChannel;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;
import org.neo4j.unsafe.impl.batchimport.input.ValueType;

public class ValueTypeTest {
    @Rule
    public final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    @Rule
    public final TestDirectory directory = TestDirectory.testDirectory((FileSystemAbstraction)this.fs);

    @Test
    public void arraysShouldCalculateCorrectLength() throws IOException {
        int[] value = new int[3];
        for (int i = 0; i < value.length; ++i) {
            value[i] = 100 + i;
        }
        ValueType valueType = ValueType.typeOf((Object)value);
        PhysicalFlushableChannel channel = new PhysicalFlushableChannel(this.fs.open(this.directory.file("file"), OpenMode.READ_WRITE));
        int length = valueType.length((Object)value);
        valueType.write((Object)value, (FlushableChannel)channel);
        int expected = 5 + value.length * 4;
        Assert.assertEquals((long)expected, (long)length);
        Assert.assertEquals((long)expected, (long)channel.position());
    }
}

