/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.test.Race;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.Groups;
import org.neo4j.unsafe.impl.batchimport.input.HeaderException;

public class GroupsTest {
    @Test
    public void shouldHandleConcurrentGetOrCreate() throws Throwable {
        Groups groups = new Groups();
        Race race = new Race();
        String name = "MyGroup";
        for (int i = 0; i < Runtime.getRuntime().availableProcessors(); ++i) {
            race.addContestant(() -> {
                Group group = groups.getOrCreate(name);
                Assert.assertEquals((long)1L, (long)group.id());
            });
        }
        race.go();
        Group otherGroup = groups.getOrCreate("MyOtherGroup");
        Assert.assertEquals((long)2L, (long)otherGroup.id());
    }

    @Test
    public void shouldSupportMixedGroupModeInGetOrCreate() {
        Groups groups = new Groups();
        Assert.assertEquals((Object)Group.GLOBAL, (Object)groups.getOrCreate(null));
        Assert.assertNotEquals((Object)Group.GLOBAL, (Object)groups.getOrCreate("Something"));
    }

    @Test
    public void shouldSupportMixedGroupModeInGetOrCreate2() {
        Groups groups = new Groups();
        Assert.assertNotEquals((Object)Group.GLOBAL, (Object)groups.getOrCreate("Something"));
        Assert.assertEquals((Object)Group.GLOBAL, (Object)groups.getOrCreate(null));
    }

    @Test
    public void shouldGetCreatedGroup() {
        Groups groups = new Groups();
        String name = "Something";
        Group createdGroup = groups.getOrCreate(name);
        Group gottenGroup = groups.get(name);
        Assert.assertSame((Object)createdGroup, (Object)gottenGroup);
    }

    @Test
    public void shouldGetGlobalGroup() {
        Groups groups = new Groups();
        groups.getOrCreate(null);
        Group group = groups.get(null);
        Assert.assertSame((Object)Group.GLOBAL, (Object)group);
    }

    @Test
    public void shouldSupportMixedGroupModeInGet() {
        Groups groups = new Groups();
        groups.getOrCreate("Something");
        Assert.assertEquals((Object)Group.GLOBAL, (Object)groups.get(null));
    }

    @Test(expected=HeaderException.class)
    public void shouldFailOnGettingNonExistentGroup() {
        Groups groups = new Groups();
        groups.get("Something");
    }
}

