/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.io.IOException;
import org.junit.Assert;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.unsafe.impl.batchimport.cache.IntArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArray;
import org.neo4j.unsafe.impl.batchimport.cache.PageCacheIntArray;
import org.neo4j.unsafe.impl.batchimport.cache.PageCacheNumberArrayConcurrencyTest;

public class PageCacheIntArrayConcurrencyTest
extends PageCacheNumberArrayConcurrencyTest {
    @Override
    protected Runnable wholeFileRacer(NumberArray array, int contestant) {
        return new WholeFileRacer((IntArray)((PageCacheIntArray)array));
    }

    @Override
    protected Runnable fileRangeRacer(NumberArray array, int contestant) {
        return new FileRangeRacer((IntArray)((PageCacheIntArray)array), contestant);
    }

    protected PageCacheIntArray getNumberArray(PagedFile file) throws IOException {
        return new PageCacheIntArray(file, 100L, 0L, 0L);
    }

    private class FileRangeRacer
    implements Runnable {
        private IntArray array;
        private int contestant;

        FileRangeRacer(IntArray array, int contestant) {
            this.array = array;
            this.contestant = contestant;
        }

        @Override
        public void run() {
            for (int o = 0; o < 2000; ++o) {
                for (int i = this.contestant; i < 100; i += 10) {
                    int value = PageCacheIntArrayConcurrencyTest.this.random.nextInt();
                    this.array.set((long)i, value);
                    Assert.assertEquals((long)value, (long)this.array.get((long)i));
                }
            }
        }
    }

    private class WholeFileRacer
    implements Runnable {
        private IntArray array;

        WholeFileRacer(IntArray array) {
            this.array = array;
        }

        @Override
        public void run() {
            for (int o = 0; o < 2000; ++o) {
                for (int i = 0; i < 100; ++i) {
                    this.array.set((long)i, i);
                    Assert.assertEquals((long)i, (long)this.array.get((long)i));
                }
            }
        }
    }
}

