/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.graphdb.Direction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.test.rule.PageCacheAndDependenciesRule;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.DataStatistics;
import org.neo4j.unsafe.impl.batchimport.ImportLogic;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipCache;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStores;

public class ImportLogicTest {
    @Rule
    public final PageCacheAndDependenciesRule storage = new PageCacheAndDependenciesRule();
    @Rule
    public final RandomRule random = new RandomRule();

    @Test
    public void closeImporterWithoutDiagnosticState() throws IOException {
        ExecutionMonitor monitor = (ExecutionMonitor)Mockito.mock(ExecutionMonitor.class);
        try (BatchingNeoStores stores = BatchingNeoStores.batchingNeoStoresWithExternalPageCache((FileSystemAbstraction)this.storage.fileSystem(), (PageCache)this.storage.pageCache(), (PageCacheTracer)PageCacheTracer.NULL, (File)this.storage.directory().directory(), (RecordFormats)RecordFormatSelector.defaultFormat(), (Configuration)Configuration.DEFAULT, (LogService)NullLogService.getInstance(), (AdditionalInitialIds)AdditionalInitialIds.EMPTY, (Config)Config.defaults());
             ImportLogic logic = new ImportLogic(this.storage.directory().directory(), this.storage.fileSystem(), stores, Configuration.DEFAULT, (LogService)NullLogService.getInstance(), monitor, RecordFormatSelector.defaultFormat(), ImportLogic.NO_MONITOR);){
            logic.success();
        }
        ((ExecutionMonitor)Mockito.verify((Object)monitor)).done(ArgumentMatchers.eq((boolean)true), ArgumentMatchers.anyLong(), ArgumentMatchers.contains((String)"Data statistics is not available."));
    }

    @Test
    public void shouldSplitUpRelationshipTypesInBatches() {
        int denseNodeThreshold = 5;
        int numberOfNodes = 100;
        int numberOfTypes = 10;
        NodeRelationshipCache cache = new NodeRelationshipCache(NumberArrayFactory.HEAP, denseNodeThreshold);
        cache.setNodeCount((long)(numberOfNodes + 1));
        Object[] directions = Direction.values();
        for (int i = 0; i < numberOfNodes; ++i) {
            int count = this.random.nextInt(1, denseNodeThreshold * 2);
            cache.setCount((long)i, (long)count, this.random.nextInt(numberOfTypes), (Direction)this.random.among(directions));
        }
        cache.countingCompleted();
        ArrayList<DataStatistics.RelationshipTypeCount> types = new ArrayList<DataStatistics.RelationshipTypeCount>();
        int numberOfRelationships = 0;
        for (int i = 0; i < numberOfTypes; ++i) {
            int count = this.random.nextInt(1, 100);
            types.add(new DataStatistics.RelationshipTypeCount(i, (long)count));
            numberOfRelationships += count;
        }
        types.sort((t1, t2) -> Long.compare(t2.getCount(), t1.getCount()));
        DataStatistics typeDistribution = new DataStatistics(0L, 0L, types.toArray(new DataStatistics.RelationshipTypeCount[types.size()]));
        long memory = cache.calculateMaxMemoryUsage((long)numberOfRelationships) * (long)numberOfTypes;
        int upToType = ImportLogic.nextSetOfTypesThatFitInMemory((DataStatistics)typeDistribution, (int)0, (long)memory, (long)cache.getNumberOfDenseNodes());
        Assert.assertEquals((long)types.size(), (long)upToType);
        memory = cache.calculateMaxMemoryUsage((long)numberOfRelationships) * (long)numberOfTypes / 3L;
        int startingFromType = 0;
        int rounds = 0;
        while (startingFromType < types.size()) {
            ++rounds;
            startingFromType = ImportLogic.nextSetOfTypesThatFitInMemory((DataStatistics)typeDistribution, (int)startingFromType, (long)memory, (long)cache.getNumberOfDenseNodes());
        }
        Assert.assertEquals((long)types.size(), (long)startingFromType);
        Assert.assertThat((Object)rounds, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(1)));
    }

    @Test
    public void shouldUseDataStatisticsCountsForPrintingFinalStats() throws IOException {
        ExecutionMonitor monitor = (ExecutionMonitor)Mockito.mock(ExecutionMonitor.class);
        try (BatchingNeoStores stores = BatchingNeoStores.batchingNeoStoresWithExternalPageCache((FileSystemAbstraction)this.storage.fileSystem(), (PageCache)this.storage.pageCache(), (PageCacheTracer)PageCacheTracer.NULL, (File)this.storage.directory().directory(), (RecordFormats)RecordFormatSelector.defaultFormat(), (Configuration)Configuration.DEFAULT, (LogService)NullLogService.getInstance(), (AdditionalInitialIds)AdditionalInitialIds.EMPTY, (Config)Config.defaults());){
            DataStatistics.RelationshipTypeCount[] relationshipTypeCounts = new DataStatistics.RelationshipTypeCount[]{new DataStatistics.RelationshipTypeCount(0, 33L), new DataStatistics.RelationshipTypeCount(1, 66L)};
            DataStatistics dataStatistics = new DataStatistics(100123L, 100456L, relationshipTypeCounts);
            try (ImportLogic logic = new ImportLogic(this.storage.directory().directory(), this.storage.fileSystem(), stores, Configuration.DEFAULT, (LogService)NullLogService.getInstance(), monitor, RecordFormatSelector.defaultFormat(), ImportLogic.NO_MONITOR);){
                logic.putState((Object)dataStatistics);
                logic.success();
            }
            ((ExecutionMonitor)Mockito.verify((Object)monitor)).done(ArgumentMatchers.eq((boolean)true), ArgumentMatchers.anyLong(), ArgumentMatchers.contains((String)dataStatistics.toString()));
        }
    }
}

