/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule;

import java.io.File;
import java.time.Clock;
import java.util.Collections;
import java.util.function.Function;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.diagnostics.DiagnosticsManager;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.DatabaseCreationContext;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.api.explicitindex.AutoIndexing;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.availability.DatabaseAvailability;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.api.ExplicitIndexProvider;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.explicitindex.InternalAutoIndexing;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.constraints.StandardConstraintSemantics;
import org.neo4j.kernel.impl.context.TransactionVersionContextSupplier;
import org.neo4j.kernel.impl.core.DatabasePanicEventGenerator;
import org.neo4j.kernel.impl.core.TokenHolders;
import org.neo4j.kernel.impl.coreapi.CoreAPIAvailabilityGuard;
import org.neo4j.kernel.impl.factory.AccessCapability;
import org.neo4j.kernel.impl.factory.CanWrite;
import org.neo4j.kernel.impl.factory.CommunityCommitProcessFactory;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.StatementLocks;
import org.neo4j.kernel.impl.locking.StatementLocksFactory;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.query.QueryEngineProvider;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.id.BufferedIdController;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.id.IdController;
import org.neo4j.kernel.impl.store.id.BufferingIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdReuseEligibility;
import org.neo4j.kernel.impl.store.id.configuration.CommunityIdTypeConfigurationProvider;
import org.neo4j.kernel.impl.store.id.configuration.IdTypeConfigurationProvider;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.log.checkpoint.StoreCopyCheckPointMutex;
import org.neo4j.kernel.impl.transaction.log.files.LogFileCreationMonitor;
import org.neo4j.kernel.impl.transaction.stats.DatabaseTransactionStats;
import org.neo4j.kernel.impl.transaction.stats.TransactionCounters;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.UnsatisfiedDependencyException;
import org.neo4j.kernel.impl.util.collection.CollectionsFactorySupplier;
import org.neo4j.kernel.impl.util.watcher.FileSystemWatcherService;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.internal.TransactionEventHandlers;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.MockedNeoStores;
import org.neo4j.test.rule.ExternalResource;
import org.neo4j.time.Clocks;
import org.neo4j.time.SystemNanoClock;

public class NeoStoreDataSourceRule
extends ExternalResource {
    private NeoStoreDataSource dataSource;

    public NeoStoreDataSource getDataSource(DatabaseLayout databaseLayout, FileSystemAbstraction fs, PageCache pageCache) {
        return this.getDataSource(databaseLayout, fs, pageCache, (DependencyResolver)new Dependencies());
    }

    public NeoStoreDataSource getDataSource(DatabaseLayout databaseLayout, FileSystemAbstraction fs, PageCache pageCache, DependencyResolver otherCustomOverriddenDependencies) {
        this.shutdownAnyRunning();
        StatementLocksFactory locksFactory = (StatementLocksFactory)Mockito.mock(StatementLocksFactory.class);
        StatementLocks statementLocks = (StatementLocks)Mockito.mock(StatementLocks.class);
        Locks.Client locks = (Locks.Client)Mockito.mock(Locks.Client.class);
        Mockito.when((Object)statementLocks.optimistic()).thenReturn((Object)locks);
        Mockito.when((Object)statementLocks.pessimistic()).thenReturn((Object)locks);
        Mockito.when((Object)locksFactory.newInstance()).thenReturn((Object)statementLocks);
        JobScheduler jobScheduler = (JobScheduler)Mockito.mock(JobScheduler.class, (Answer)Mockito.RETURNS_MOCKS);
        Monitors monitors = new Monitors();
        Dependencies mutableDependencies = new Dependencies(otherCustomOverriddenDependencies);
        Config config = NeoStoreDataSourceRule.dependency(mutableDependencies, Config.class, deps -> Config.defaults());
        config.augment(GraphDatabaseSettings.default_schema_provider, IndexProvider.EMPTY.getProviderDescriptor().name());
        LogService logService = NeoStoreDataSourceRule.dependency(mutableDependencies, LogService.class, deps -> new SimpleLogService((LogProvider)NullLogProvider.getInstance()));
        IdGeneratorFactory idGeneratorFactory = NeoStoreDataSourceRule.dependency(mutableDependencies, IdGeneratorFactory.class, deps -> new DefaultIdGeneratorFactory(fs));
        IdTypeConfigurationProvider idConfigurationProvider = NeoStoreDataSourceRule.dependency(mutableDependencies, IdTypeConfigurationProvider.class, deps -> new CommunityIdTypeConfigurationProvider());
        DatabaseHealth databaseHealth = NeoStoreDataSourceRule.dependency(mutableDependencies, DatabaseHealth.class, deps -> new DatabaseHealth((DatabasePanicEventGenerator)Mockito.mock(DatabasePanicEventGenerator.class), (Log)NullLog.getInstance()));
        SystemNanoClock clock = NeoStoreDataSourceRule.dependency(mutableDependencies, SystemNanoClock.class, deps -> Clocks.nanoClock());
        TransactionMonitor transactionMonitor = NeoStoreDataSourceRule.dependency(mutableDependencies, TransactionMonitor.class, deps -> new DatabaseTransactionStats());
        DatabaseAvailabilityGuard databaseAvailabilityGuard = NeoStoreDataSourceRule.dependency(mutableDependencies, DatabaseAvailabilityGuard.class, deps -> new DatabaseAvailabilityGuard("graph.db", (Clock)deps.resolveDependency(SystemNanoClock.class), (Log)NullLog.getInstance()));
        NeoStoreDataSourceRule.dependency(mutableDependencies, DiagnosticsManager.class, deps -> new DiagnosticsManager((Log)NullLog.getInstance()));
        NeoStoreDataSourceRule.dependency(mutableDependencies, IndexProvider.class, deps -> IndexProvider.EMPTY);
        this.dataSource = new NeoStoreDataSource((DatabaseCreationContext)new TestDatabaseCreationContext("graph.db", databaseLayout, config, idGeneratorFactory, logService, (JobScheduler)Mockito.mock(JobScheduler.class, (Answer)Mockito.RETURNS_MOCKS), (TokenNameLookup)Mockito.mock(TokenNameLookup.class), (DependencyResolver)mutableDependencies, MockedNeoStores.mockedTokenHolders(), locksFactory, (SchemaWriteGuard)Mockito.mock(SchemaWriteGuard.class), (TransactionEventHandlers)Mockito.mock(TransactionEventHandlers.class), IndexingService.NO_MONITOR, fs, transactionMonitor, databaseHealth, (LogFileCreationMonitor)Mockito.mock(LogFileCreationMonitor.class), TransactionHeaderInformationFactory.DEFAULT, (CommitProcessFactory)new CommunityCommitProcessFactory(), (AutoIndexing)Mockito.mock(InternalAutoIndexing.class), (IndexConfigStore)Mockito.mock(IndexConfigStore.class), (ExplicitIndexProvider)Mockito.mock(ExplicitIndexProvider.class), pageCache, (ConstraintSemantics)new StandardConstraintSemantics(), monitors, new Tracers("null", (Log)NullLog.getInstance(), monitors, jobScheduler, clock), (Procedures)Mockito.mock(Procedures.class), IOLimiter.UNLIMITED, databaseAvailabilityGuard, clock, (AccessCapability)new CanWrite(), new StoreCopyCheckPointMutex(), RecoveryCleanupWorkCollector.immediate(), (IdController)new BufferedIdController(new BufferingIdGeneratorFactory(idGeneratorFactory, IdReuseEligibility.ALWAYS, idConfigurationProvider), jobScheduler), DatabaseInfo.COMMUNITY, (VersionContextSupplier)new TransactionVersionContextSupplier(), CollectionsFactorySupplier.ON_HEAP, Collections.emptyList(), file -> FileSystemWatcherService.EMPTY_WATCHER, new GraphDatabaseFacade(), Iterables.empty()));
        return this.dataSource;
    }

    private static <T> T dependency(Dependencies dependencies, Class<T> type, Function<DependencyResolver, T> defaultSupplier) {
        try {
            return (T)dependencies.resolveDependency(type);
        }
        catch (IllegalArgumentException | UnsatisfiedDependencyException e) {
            return (T)dependencies.satisfyDependency(defaultSupplier.apply((DependencyResolver)dependencies));
        }
    }

    private void shutdownAnyRunning() {
        if (this.dataSource != null) {
            this.dataSource.stop();
        }
    }

    protected void after(boolean successful) {
        this.shutdownAnyRunning();
    }

    private static class TestDatabaseCreationContext
    implements DatabaseCreationContext {
        private final String databaseName;
        private final DatabaseLayout databaseLayout;
        private final Config config;
        private final IdGeneratorFactory idGeneratorFactory;
        private final LogService logService;
        private final JobScheduler scheduler;
        private final TokenNameLookup tokenNameLookup;
        private final DependencyResolver dependencyResolver;
        private final TokenHolders tokenHolders;
        private final StatementLocksFactory statementLocksFactory;
        private final SchemaWriteGuard schemaWriteGuard;
        private final TransactionEventHandlers transactionEventHandlers;
        private final IndexingService.Monitor indexingServiceMonitor;
        private final FileSystemAbstraction fs;
        private final TransactionMonitor transactionMonitor;
        private final DatabaseHealth databaseHealth;
        private final LogFileCreationMonitor physicalLogMonitor;
        private final TransactionHeaderInformationFactory transactionHeaderInformationFactory;
        private final CommitProcessFactory commitProcessFactory;
        private final AutoIndexing autoIndexing;
        private final IndexConfigStore indexConfigStore;
        private final ExplicitIndexProvider explicitIndexProvider;
        private final PageCache pageCache;
        private final ConstraintSemantics constraintSemantics;
        private final Monitors monitors;
        private final Tracers tracers;
        private final Procedures procedures;
        private final IOLimiter ioLimiter;
        private final DatabaseAvailabilityGuard databaseAvailabilityGuard;
        private final SystemNanoClock clock;
        private final AccessCapability accessCapability;
        private final StoreCopyCheckPointMutex storeCopyCheckPointMutex;
        private final RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;
        private final IdController idController;
        private final DatabaseInfo databaseInfo;
        private final VersionContextSupplier versionContextSupplier;
        private final CollectionsFactorySupplier collectionsFactorySupplier;
        private final Iterable<KernelExtensionFactory<?>> kernelExtensionFactories;
        private final Function<File, FileSystemWatcherService> watcherServiceFactory;
        private final GraphDatabaseFacade facade;
        private final Iterable<QueryEngineProvider> engineProviders;
        private final DatabaseAvailability databaseAvailability;
        private final CoreAPIAvailabilityGuard coreAPIAvailabilityGuard;

        TestDatabaseCreationContext(String databaseName, DatabaseLayout databaseLayout, Config config, IdGeneratorFactory idGeneratorFactory, LogService logService, JobScheduler scheduler, TokenNameLookup tokenNameLookup, DependencyResolver dependencyResolver, TokenHolders tokenHolders, StatementLocksFactory statementLocksFactory, SchemaWriteGuard schemaWriteGuard, TransactionEventHandlers transactionEventHandlers, IndexingService.Monitor indexingServiceMonitor, FileSystemAbstraction fs, TransactionMonitor transactionMonitor, DatabaseHealth databaseHealth, LogFileCreationMonitor physicalLogMonitor, TransactionHeaderInformationFactory transactionHeaderInformationFactory, CommitProcessFactory commitProcessFactory, AutoIndexing autoIndexing, IndexConfigStore indexConfigStore, ExplicitIndexProvider explicitIndexProvider, PageCache pageCache, ConstraintSemantics constraintSemantics, Monitors monitors, Tracers tracers, Procedures procedures, IOLimiter ioLimiter, DatabaseAvailabilityGuard databaseAvailabilityGuard, SystemNanoClock clock, AccessCapability accessCapability, StoreCopyCheckPointMutex storeCopyCheckPointMutex, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, IdController idController, DatabaseInfo databaseInfo, VersionContextSupplier versionContextSupplier, CollectionsFactorySupplier collectionsFactorySupplier, Iterable<KernelExtensionFactory<?>> kernelExtensionFactories, Function<File, FileSystemWatcherService> watcherServiceFactory, GraphDatabaseFacade facade, Iterable<QueryEngineProvider> engineProviders) {
            this.databaseName = databaseName;
            this.databaseLayout = databaseLayout;
            this.config = config;
            this.idGeneratorFactory = idGeneratorFactory;
            this.logService = logService;
            this.scheduler = scheduler;
            this.tokenNameLookup = tokenNameLookup;
            this.dependencyResolver = dependencyResolver;
            this.tokenHolders = tokenHolders;
            this.statementLocksFactory = statementLocksFactory;
            this.schemaWriteGuard = schemaWriteGuard;
            this.transactionEventHandlers = transactionEventHandlers;
            this.indexingServiceMonitor = indexingServiceMonitor;
            this.fs = fs;
            this.transactionMonitor = transactionMonitor;
            this.databaseHealth = databaseHealth;
            this.physicalLogMonitor = physicalLogMonitor;
            this.transactionHeaderInformationFactory = transactionHeaderInformationFactory;
            this.commitProcessFactory = commitProcessFactory;
            this.autoIndexing = autoIndexing;
            this.indexConfigStore = indexConfigStore;
            this.explicitIndexProvider = explicitIndexProvider;
            this.pageCache = pageCache;
            this.constraintSemantics = constraintSemantics;
            this.monitors = monitors;
            this.tracers = tracers;
            this.procedures = procedures;
            this.ioLimiter = ioLimiter;
            this.databaseAvailabilityGuard = databaseAvailabilityGuard;
            this.clock = clock;
            this.accessCapability = accessCapability;
            this.storeCopyCheckPointMutex = storeCopyCheckPointMutex;
            this.recoveryCleanupWorkCollector = recoveryCleanupWorkCollector;
            this.idController = idController;
            this.databaseInfo = databaseInfo;
            this.versionContextSupplier = versionContextSupplier;
            this.collectionsFactorySupplier = collectionsFactorySupplier;
            this.kernelExtensionFactories = kernelExtensionFactories;
            this.watcherServiceFactory = watcherServiceFactory;
            this.facade = facade;
            this.engineProviders = engineProviders;
            this.databaseAvailability = new DatabaseAvailability((AvailabilityGuard)databaseAvailabilityGuard, (TransactionCounters)Mockito.mock(TransactionCounters.class), (Clock)clock, 0L);
            this.coreAPIAvailabilityGuard = new CoreAPIAvailabilityGuard(databaseAvailabilityGuard, 0L);
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public DatabaseLayout getDatabaseLayout() {
            return this.databaseLayout;
        }

        public Config getConfig() {
            return this.config;
        }

        public IdGeneratorFactory getIdGeneratorFactory() {
            return this.idGeneratorFactory;
        }

        public LogService getLogService() {
            return this.logService;
        }

        public JobScheduler getScheduler() {
            return this.scheduler;
        }

        public TokenNameLookup getTokenNameLookup() {
            return this.tokenNameLookup;
        }

        public DependencyResolver getGlobalDependencies() {
            return this.dependencyResolver;
        }

        public DependencyResolver getDependencyResolver() {
            return this.dependencyResolver;
        }

        public TokenHolders getTokenHolders() {
            return this.tokenHolders;
        }

        public Locks getLocks() {
            return (Locks)Mockito.mock(Locks.class);
        }

        public StatementLocksFactory getStatementLocksFactory() {
            return this.statementLocksFactory;
        }

        public SchemaWriteGuard getSchemaWriteGuard() {
            return this.schemaWriteGuard;
        }

        public TransactionEventHandlers getTransactionEventHandlers() {
            return this.transactionEventHandlers;
        }

        public IndexingService.Monitor getIndexingServiceMonitor() {
            return this.indexingServiceMonitor;
        }

        public FileSystemAbstraction getFs() {
            return this.fs;
        }

        public TransactionMonitor getTransactionMonitor() {
            return this.transactionMonitor;
        }

        public DatabaseHealth getDatabaseHealth() {
            return this.databaseHealth;
        }

        public LogFileCreationMonitor getPhysicalLogMonitor() {
            return this.physicalLogMonitor;
        }

        public TransactionHeaderInformationFactory getTransactionHeaderInformationFactory() {
            return this.transactionHeaderInformationFactory;
        }

        public CommitProcessFactory getCommitProcessFactory() {
            return this.commitProcessFactory;
        }

        public AutoIndexing getAutoIndexing() {
            return this.autoIndexing;
        }

        public IndexConfigStore getIndexConfigStore() {
            return this.indexConfigStore;
        }

        public ExplicitIndexProvider getExplicitIndexProvider() {
            return this.explicitIndexProvider;
        }

        public PageCache getPageCache() {
            return this.pageCache;
        }

        public ConstraintSemantics getConstraintSemantics() {
            return this.constraintSemantics;
        }

        public Monitors getMonitors() {
            return this.monitors;
        }

        public Tracers getTracers() {
            return this.tracers;
        }

        public Procedures getProcedures() {
            return this.procedures;
        }

        public IOLimiter getIoLimiter() {
            return this.ioLimiter;
        }

        public DatabaseAvailabilityGuard getDatabaseAvailabilityGuard() {
            return this.databaseAvailabilityGuard;
        }

        public CoreAPIAvailabilityGuard getCoreAPIAvailabilityGuard() {
            return this.coreAPIAvailabilityGuard;
        }

        public SystemNanoClock getClock() {
            return this.clock;
        }

        public AccessCapability getAccessCapability() {
            return this.accessCapability;
        }

        public StoreCopyCheckPointMutex getStoreCopyCheckPointMutex() {
            return this.storeCopyCheckPointMutex;
        }

        public RecoveryCleanupWorkCollector getRecoveryCleanupWorkCollector() {
            return this.recoveryCleanupWorkCollector;
        }

        public IdController getIdController() {
            return this.idController;
        }

        public DatabaseInfo getDatabaseInfo() {
            return this.databaseInfo;
        }

        public VersionContextSupplier getVersionContextSupplier() {
            return this.versionContextSupplier;
        }

        public CollectionsFactorySupplier getCollectionsFactorySupplier() {
            return this.collectionsFactorySupplier;
        }

        public Iterable<KernelExtensionFactory<?>> getKernelExtensionFactories() {
            return this.kernelExtensionFactories;
        }

        public Function<File, FileSystemWatcherService> getWatcherServiceFactory() {
            return this.watcherServiceFactory;
        }

        public GraphDatabaseFacade getFacade() {
            return this.facade;
        }

        public Iterable<QueryEngineProvider> getEngineProviders() {
            return this.engineProviders;
        }

        public DatabaseAvailability getDatabaseAvailability() {
            return this.databaseAvailability;
        }
    }
}

