/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api.schema;

import org.neo4j.collection.PrimitiveLongResourceCollections;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.graphdb.Resource;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.kernel.impl.index.schema.NodeValueIterator;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSampler;
import org.neo4j.values.storable.Value;

public class QueryResultComparingIndexReader
implements IndexReader {
    private final IndexReader actual;

    public QueryResultComparingIndexReader(IndexReader actual) {
        this.actual = actual;
    }

    public long countIndexedNodes(long nodeId, int[] propertyKeyIds, Value ... propertyValues) {
        return this.actual.countIndexedNodes(nodeId, propertyKeyIds, propertyValues);
    }

    public IndexSampler createSampler() {
        return this.actual.createSampler();
    }

    public PrimitiveLongResourceIterator query(IndexQuery ... predicates) throws IndexNotApplicableKernelException {
        final PrimitiveLongResourceIterator mainResult = this.actual.query(predicates);
        final NodeValueIterator otherResult = new NodeValueIterator();
        this.actual.query((IndexProgressor.NodeValueClient)otherResult, IndexOrder.NONE, false, predicates);
        return new PrimitiveLongResourceCollections.PrimitiveLongBaseResourceIterator((Resource)mainResult){

            protected boolean fetchNext() {
                if (mainResult.hasNext()) {
                    long mainValue = mainResult.next();
                    if (!otherResult.hasNext()) {
                        throw new IllegalStateException(String.format("Legacy query method returned %d, but new query method didn't have more values in it", mainValue));
                    }
                    long otherValue = otherResult.next();
                    if (mainValue != otherValue) {
                        throw new IllegalStateException(String.format("Query methods disagreeing on next value legacy:%d new:%d", mainValue, otherValue));
                    }
                    return this.next(mainValue);
                }
                if (otherResult.hasNext()) {
                    throw new IllegalStateException(String.format("Legacy query method exhausted, but new query method had more %d", otherResult.next()));
                }
                return false;
            }

            public void close() {
                super.close();
                otherResult.close();
            }
        };
    }

    public void query(final IndexProgressor.NodeValueClient client, IndexOrder indexOrder, boolean needsValues, IndexQuery ... query) throws IndexNotApplicableKernelException {
        final PrimitiveLongResourceIterator otherResult = this.actual.query(query);
        IndexProgressor.NodeValueClient wrappedClient = new IndexProgressor.NodeValueClient(){
            private long mainValue;

            public void initialize(IndexDescriptor descriptor, final IndexProgressor progressor, IndexQuery[] query, IndexOrder indexOrder, boolean needsValues) {
                IndexProgressor wrappedProgressor = new IndexProgressor(){

                    public boolean next() {
                        mainValue = -1L;
                        if (progressor.next()) {
                            if (!otherResult.hasNext()) {
                                throw new IllegalStateException(String.format("new query method returned %d, but legacy query method didn't have more values in it", mainValue));
                            }
                            long otherValue = otherResult.next();
                            if (mainValue != otherValue) {
                                throw new IllegalStateException(String.format("Query methods disagreeing on next value new:%d legacy:%d", mainValue, otherValue));
                            }
                            return true;
                        }
                        if (otherResult.hasNext()) {
                            throw new IllegalStateException(String.format("New query method exhausted, but legacy query method had more %d", otherResult.next()));
                        }
                        return false;
                    }

                    public void close() {
                        progressor.close();
                        otherResult.close();
                    }
                };
                client.initialize(descriptor, wrappedProgressor, query, indexOrder, needsValues);
            }

            public boolean acceptNode(long reference, Value ... values) {
                this.mainValue = reference;
                return client.acceptNode(reference, values);
            }

            public boolean needsValues() {
                return client.needsValues();
            }
        };
        this.actual.query(wrappedClient, indexOrder, needsValues, query);
    }

    public void distinctValues(IndexProgressor.NodeValueClient client, NodePropertyAccessor propertyAccessor, boolean needsValues) {
        this.actual.distinctValues(client, propertyAccessor, needsValues);
    }

    public boolean hasFullValuePrecision(IndexQuery ... predicates) {
        return this.actual.hasFullValuePrecision(predicates);
    }

    public void close() {
        this.actual.close();
    }
}

