/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.monitoring;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.monitoring.Monitors;

public class MonitorsTest {
    @Test
    public void shouldProvideNoOpDelegate() {
        Monitors monitors = new Monitors();
        MyMonitor monitor = (MyMonitor)monitors.newMonitor(MyMonitor.class, new String[0]);
        monitor.aVoid();
        monitor.takesArgs("ha", 12L, new Object());
    }

    @Test
    public void shouldRegister() {
        Monitors monitors = new Monitors();
        MyMonitor listener = (MyMonitor)Mockito.mock(MyMonitor.class);
        MyMonitor monitor = (MyMonitor)monitors.newMonitor(MyMonitor.class, new String[0]);
        Object obj = new Object();
        monitors.addMonitorListener((Object)listener, new String[0]);
        monitor.aVoid();
        monitor.takesArgs("ha", 12L, obj);
        ((MyMonitor)Mockito.verify((Object)listener)).aVoid();
        ((MyMonitor)Mockito.verify((Object)listener)).takesArgs("ha", 12L, obj);
    }

    @Test
    public void shouldUnregister() {
        Monitors monitors = new Monitors();
        MyMonitor listener = (MyMonitor)Mockito.mock(MyMonitor.class);
        MyMonitor monitor = (MyMonitor)monitors.newMonitor(MyMonitor.class, new String[0]);
        Object obj = new Object();
        monitors.addMonitorListener((Object)listener, new String[0]);
        monitors.removeMonitorListener((Object)listener);
        monitor.aVoid();
        monitor.takesArgs("ha", 12L, obj);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }

    @Test
    public void shouldRespectTags() {
        Monitors monitors = new Monitors();
        MyMonitor listener = (MyMonitor)Mockito.mock(MyMonitor.class);
        MyMonitor monitorTag1 = (MyMonitor)monitors.newMonitor(MyMonitor.class, new String[]{"tag1"});
        MyMonitor monitorTag2 = (MyMonitor)monitors.newMonitor(MyMonitor.class, new String[]{"tag2"});
        monitors.addMonitorListener((Object)listener, new String[]{"tag2"});
        monitorTag1.aVoid();
        Mockito.verifyZeroInteractions((Object[])new Object[]{listener});
        monitorTag2.aVoid();
        ((MyMonitor)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).aVoid();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }

    @Test
    public void shouldTellIfMonitorHasListeners() {
        Monitors monitors = new Monitors();
        MyMonitor listener = (MyMonitor)Mockito.mock(MyMonitor.class);
        monitors.newMonitor(MyMonitor.class, new String[0]);
        Assert.assertFalse((boolean)monitors.hasListeners(MyMonitor.class));
        monitors.addMonitorListener((Object)listener, new String[0]);
        Assert.assertTrue((boolean)monitors.hasListeners(MyMonitor.class));
        monitors.removeMonitorListener((Object)listener);
        Assert.assertFalse((boolean)monitors.hasListeners(MyMonitor.class));
    }

    @Test
    public void multipleListenersRegistration() {
        Monitors monitors = new Monitors();
        MyMonitor listener1 = (MyMonitor)Mockito.mock(MyMonitor.class);
        MyMonitor listener2 = (MyMonitor)Mockito.mock(MyMonitor.class);
        Assert.assertFalse((boolean)monitors.hasListeners(MyMonitor.class));
        monitors.addMonitorListener((Object)listener1, new String[0]);
        monitors.addMonitorListener((Object)listener2, new String[0]);
        Assert.assertTrue((boolean)monitors.hasListeners(MyMonitor.class));
        monitors.removeMonitorListener((Object)listener1);
        Assert.assertTrue((boolean)monitors.hasListeners(MyMonitor.class));
        monitors.removeMonitorListener((Object)listener2);
        Assert.assertFalse((boolean)monitors.hasListeners(MyMonitor.class));
    }

    @Test
    public void eventShouldBubbleUp() {
        Monitors parent = new Monitors();
        MyMonitor parentListener = (MyMonitor)Mockito.mock(MyMonitor.class);
        parent.addMonitorListener((Object)parentListener, new String[0]);
        Monitors child = new Monitors(parent);
        MyMonitor childListener = (MyMonitor)Mockito.mock(MyMonitor.class);
        child.addMonitorListener((Object)childListener, new String[0]);
        MyMonitor parentMonitor = (MyMonitor)parent.newMonitor(MyMonitor.class, new String[0]);
        parentMonitor.aVoid();
        ((MyMonitor)Mockito.verify((Object)parentListener, (VerificationMode)Mockito.times((int)1))).aVoid();
        Mockito.verifyZeroInteractions((Object[])new Object[]{childListener});
        MyMonitor childMonitor = (MyMonitor)child.newMonitor(MyMonitor.class, new String[0]);
        childMonitor.aVoid();
        ((MyMonitor)Mockito.verify((Object)parentListener, (VerificationMode)Mockito.times((int)2))).aVoid();
        ((MyMonitor)Mockito.verify((Object)childListener, (VerificationMode)Mockito.times((int)1))).aVoid();
    }

    static interface MyMonitor {
        public void aVoid();

        public void takesArgs(String var1, long var2, Object ... var4);
    }
}

