/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.neo4j.kernel.internal.Version;

public class VersionTest {
    @Test
    public void shouldExposeCleanAndDetailedVersions() {
        MatcherAssert.assertThat((Object)this.version("1.2.3-M01,abcdef012345").getReleaseVersion(), (Matcher)CoreMatchers.equalTo((Object)"1.2.3-M01"));
        MatcherAssert.assertThat((Object)this.version("1.2.3-M01,abcdef012345").getVersion(), (Matcher)CoreMatchers.equalTo((Object)"1.2.3-M01,abcdef012345"));
        MatcherAssert.assertThat((Object)this.version("1.2.3-M01,abcdef012345-dirty").getVersion(), (Matcher)CoreMatchers.equalTo((Object)"1.2.3-M01,abcdef012345-dirty"));
        MatcherAssert.assertThat((Object)this.version("1.2.3,abcdef012345").getReleaseVersion(), (Matcher)CoreMatchers.equalTo((Object)"1.2.3"));
        MatcherAssert.assertThat((Object)this.version("1.2.3,abcdef012345").getVersion(), (Matcher)CoreMatchers.equalTo((Object)"1.2.3,abcdef012345"));
        MatcherAssert.assertThat((Object)this.version("1.2.3,abcdef012345-dirty").getVersion(), (Matcher)CoreMatchers.equalTo((Object)"1.2.3,abcdef012345-dirty"));
        MatcherAssert.assertThat((Object)this.version("1.2.3-GA,abcdef012345").getReleaseVersion(), (Matcher)CoreMatchers.equalTo((Object)"1.2.3-GA"));
        MatcherAssert.assertThat((Object)this.version("1.2.3-GA,abcdef012345").getVersion(), (Matcher)CoreMatchers.equalTo((Object)"1.2.3-GA,abcdef012345"));
        MatcherAssert.assertThat((Object)this.version("1.2.3-GA,abcdef012345-dirty").getVersion(), (Matcher)CoreMatchers.equalTo((Object)"1.2.3-GA,abcdef012345-dirty"));
        MatcherAssert.assertThat((Object)this.version("1.2.3M01,abcdef012345").getReleaseVersion(), (Matcher)CoreMatchers.equalTo((Object)"1.2.3M01"));
        MatcherAssert.assertThat((Object)this.version("1.2.3M01,abcdef012345").getVersion(), (Matcher)CoreMatchers.equalTo((Object)"1.2.3M01,abcdef012345"));
        MatcherAssert.assertThat((Object)this.version("1.2.3M01,abcdef012345-dirty").getVersion(), (Matcher)CoreMatchers.equalTo((Object)"1.2.3M01,abcdef012345-dirty"));
        MatcherAssert.assertThat((Object)this.version("1.2").getReleaseVersion(), (Matcher)CoreMatchers.equalTo((Object)"1.2"));
        MatcherAssert.assertThat((Object)this.version("1.2").getVersion(), (Matcher)CoreMatchers.equalTo((Object)"1.2"));
        MatcherAssert.assertThat((Object)this.version("0").getReleaseVersion(), (Matcher)CoreMatchers.equalTo((Object)"0"));
        MatcherAssert.assertThat((Object)this.version("0").getVersion(), (Matcher)CoreMatchers.equalTo((Object)"0"));
    }

    private Version version(String version) {
        return new Version("test-component", version);
    }
}

