/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.util.collection.CapacityLimitingBlockAllocatorDecorator;
import org.neo4j.kernel.impl.util.collection.OffHeapBlockAllocator;
import org.neo4j.memory.MemoryAllocationTracker;

class CapacityLimitingBlockAllocatorDecoratorTest {
    CapacityLimitingBlockAllocatorDecoratorTest() {
    }

    @Test
    void maxMemoryLimit() {
        MemoryAllocationTracker tracker = (MemoryAllocationTracker)Mockito.mock(MemoryAllocationTracker.class);
        OffHeapBlockAllocator allocator = (OffHeapBlockAllocator)Mockito.mock(OffHeapBlockAllocator.class);
        Mockito.when((Object)allocator.allocate(ArgumentMatchers.anyLong(), (MemoryAllocationTracker)ArgumentMatchers.any(MemoryAllocationTracker.class))).then(invocation -> {
            long size = (Long)invocation.getArgument(0);
            return new OffHeapBlockAllocator.MemoryBlock(0L, size, 0L, size);
        });
        CapacityLimitingBlockAllocatorDecorator decorator = new CapacityLimitingBlockAllocatorDecorator(allocator, 1024L);
        ArrayList<OffHeapBlockAllocator.MemoryBlock> blocks = new ArrayList<OffHeapBlockAllocator.MemoryBlock>();
        for (int i = 0; i < 8; ++i) {
            OffHeapBlockAllocator.MemoryBlock block = decorator.allocate(128L, tracker);
            blocks.add(block);
        }
        Assertions.assertThrows(RuntimeException.class, () -> decorator.allocate(128L, tracker));
        decorator.free((OffHeapBlockAllocator.MemoryBlock)blocks.remove(0), tracker);
        Assertions.assertDoesNotThrow(() -> decorator.allocate(128L, tracker));
        Assertions.assertThrows(RuntimeException.class, () -> decorator.allocate(256L, tracker));
        decorator.free((OffHeapBlockAllocator.MemoryBlock)blocks.remove(0), tracker);
        Assertions.assertThrows(RuntimeException.class, () -> decorator.allocate(256L, tracker));
        decorator.free((OffHeapBlockAllocator.MemoryBlock)blocks.remove(0), tracker);
        Assertions.assertDoesNotThrow(() -> decorator.allocate(256L, tracker));
    }
}

