/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.function.IntPredicate;
import java.util.function.Supplier;
import org.eclipse.collections.impl.block.factory.primitive.IntPredicates;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageReader;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.transaction.state.storeview.PropertyAwareEntityStoreScan;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.schema.PopulationProgress;

public class PropertyAwareEntityStoreScanTest {
    private final LockService locks = (LockService)Mockito.mock(LockService.class, (Answer)Mockito.RETURNS_MOCKS);
    private final NodeStore nodeStore = (NodeStore)Mockito.mock(NodeStore.class);
    private final PropertyStore propertyStore = (PropertyStore)Mockito.mock(PropertyStore.class);
    private final NeoStores neoStores = (NeoStores)Mockito.mock(NeoStores.class);

    @Before
    public void before() {
        Mockito.when((Object)this.neoStores.getNodeStore()).thenReturn((Object)this.nodeStore);
        Mockito.when((Object)this.neoStores.getPropertyStore()).thenReturn((Object)this.propertyStore);
    }

    @Test
    public void shouldGiveBackCompletionPercentage() {
        final long total = 10L;
        Mockito.when((Object)this.nodeStore.getHighId()).thenReturn((Object)total);
        NodeRecord emptyRecord = new NodeRecord(0L);
        NodeRecord inUseRecord = new NodeRecord(42L);
        inUseRecord.setInUse(true);
        Mockito.when((Object)this.nodeStore.newRecord()).thenReturn((Object)emptyRecord);
        Mockito.when((Object)this.nodeStore.getRecord(ArgumentMatchers.anyLong(), (AbstractBaseRecord)ArgumentMatchers.any(NodeRecord.class), (RecordLoad)ArgumentMatchers.any(RecordLoad.class))).thenReturn((Object)inUseRecord, (Object[])new NodeRecord[]{inUseRecord, inUseRecord, inUseRecord, inUseRecord, inUseRecord, inUseRecord, inUseRecord, inUseRecord, inUseRecord});
        final PercentageSupplier percentageSupplier = new PercentageSupplier();
        PropertyAwareEntityStoreScan<StorageNodeCursor, RuntimeException> scan = new PropertyAwareEntityStoreScan<StorageNodeCursor, RuntimeException>((StorageReader)new RecordStorageReader(this.neoStores), total, (IntPredicate)IntPredicates.alwaysTrue(), id -> this.locks.acquireNodeLock(id, LockService.LockType.READ_LOCK)){
            private int read;

            public boolean process(StorageNodeCursor node) {
                ++this.read;
                float expected = (float)this.read / (float)total;
                float actual = percentageSupplier.get().floatValue();
                Assert.assertEquals((String)String.format("%f==%f", Float.valueOf(expected), Float.valueOf(actual)), (double)expected, (double)actual, (double)0.0);
                return false;
            }

            protected StorageNodeCursor allocateCursor(StorageReader storageReader) {
                return storageReader.allocateNodeCursor();
            }
        };
        percentageSupplier.setStoreScan((StoreScan<?>)scan);
        scan.run();
    }

    private static class PercentageSupplier
    implements Supplier<Float> {
        private StoreScan<?> storeScan;

        private PercentageSupplier() {
        }

        @Override
        public Float get() {
            Assert.assertNotNull(this.storeScan);
            PopulationProgress progress = this.storeScan.getProgress();
            return Float.valueOf((float)progress.getCompleted() / (float)progress.getTotal());
        }

        void setStoreScan(StoreScan<?> storeScan) {
            this.storeScan = storeScan;
        }
    }
}

