/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.api.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.state.IntegrityValidator;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class IntegrityValidatorTest {
    @Test
    public void shouldValidateUniquenessIndexes() throws Exception {
        NeoStores store = (NeoStores)Mockito.mock(NeoStores.class);
        IndexingService indexes = (IndexingService)Mockito.mock(IndexingService.class);
        IntegrityValidator validator = new IntegrityValidator(store, indexes);
        UniquenessConstraintDescriptor constraint = ConstraintDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{1});
        ((IndexingService)Mockito.doThrow((Throwable[])new Throwable[]{new UniquePropertyValueValidationException((IndexBackedConstraintDescriptor)constraint, ConstraintValidationException.Phase.VERIFICATION, (Throwable)new RuntimeException())}).when((Object)indexes)).validateIndex(2L);
        ConstraintRule record = ConstraintRule.constraintRule((long)1L, (IndexBackedConstraintDescriptor)constraint, (long)2L);
        try {
            validator.validateSchemaRule((SchemaRule)record);
            Assert.fail((String)"Should have thrown integrity error.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void deletingNodeWithRelationshipsIsNotAllowed() {
        NeoStores store = (NeoStores)Mockito.mock(NeoStores.class);
        IndexingService indexes = (IndexingService)Mockito.mock(IndexingService.class);
        IntegrityValidator validator = new IntegrityValidator(store, indexes);
        NodeRecord record = new NodeRecord(1L, false, 1L, -1L);
        record.setInUse(false);
        try {
            validator.validateNodeRecord(record);
            Assert.fail((String)"Should have thrown integrity error.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void transactionsStartedBeforeAConstraintWasCreatedAreDisallowed() {
        NeoStores store = (NeoStores)Mockito.mock(NeoStores.class);
        MetaDataStore metaDataStore = (MetaDataStore)Mockito.mock(MetaDataStore.class);
        Mockito.when((Object)store.getMetaDataStore()).thenReturn((Object)metaDataStore);
        IndexingService indexes = (IndexingService)Mockito.mock(IndexingService.class);
        Mockito.when((Object)metaDataStore.getLatestConstraintIntroducingTx()).thenReturn((Object)10L);
        IntegrityValidator validator = new IntegrityValidator(store, indexes);
        try {
            validator.validateTransactionStartKnowledge(1L);
            Assert.fail((String)"Should have thrown integrity error.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

