/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.reverse;

import java.io.IOException;
import java.util.ArrayList;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.GivenTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.UnsupportedLogVersionException;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.reverse.ReverseTransactionCursorLoggingMonitor;
import org.neo4j.kernel.impl.transaction.log.reverse.ReversedSingleFileTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.reverse.ReversedTransactionCursorMonitor;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.WritableChannel;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class ReversedSingleFileTransactionCursorTest {
    private final DefaultFileSystemRule fs = new DefaultFileSystemRule();
    private final TestDirectory directory = TestDirectory.testDirectory((FileSystemAbstraction)this.fs);
    private final LifeRule life = new LifeRule(true);
    private final RandomRule random = new RandomRule();
    private final ExpectedException expectedException = ExpectedException.none();
    @Rule
    public final RuleChain rules = RuleChain.outerRule((TestRule)this.random).around((TestRule)this.fs).around((TestRule)this.directory).around((TestRule)this.life).around((TestRule)this.expectedException);
    private long txId = 1L;
    private LogProvider logProvider = new AssertableLogProvider(true);
    private ReverseTransactionCursorLoggingMonitor monitor = new ReverseTransactionCursorLoggingMonitor(this.logProvider.getLog(ReversedSingleFileTransactionCursor.class));
    private LogFile logFile;

    @Before
    public void setUp() throws IOException {
        SimpleLogVersionRepository logVersionRepository = new SimpleLogVersionRepository();
        SimpleTransactionIdStore transactionIdStore = new SimpleTransactionIdStore();
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.directory.databaseLayout(), (FileSystemAbstraction)this.fs).withLogVersionRepository((LogVersionRepository)logVersionRepository).withTransactionIdStore((TransactionIdStore)transactionIdStore).build();
        this.life.add((Lifecycle)logFiles);
        this.logFile = logFiles.getLogFile();
    }

    @Test
    public void shouldHandleVerySmallTransactions() throws Exception {
        this.writeTransactions(10, 1, 1);
        CommittedTransactionRepresentation[] readTransactions = this.readAllFromReversedCursor();
        this.assertTransactionRange(readTransactions, this.txId, 1L);
    }

    @Test
    public void shouldHandleManyVerySmallTransactions() throws Exception {
        this.writeTransactions(20000, 1, 1);
        CommittedTransactionRepresentation[] readTransactions = this.readAllFromReversedCursor();
        this.assertTransactionRange(readTransactions, this.txId, 1L);
    }

    @Test
    public void shouldHandleLargeTransactions() throws Exception {
        this.writeTransactions(10, 1000, 1000);
        CommittedTransactionRepresentation[] readTransactions = this.readAllFromReversedCursor();
        this.assertTransactionRange(readTransactions, this.txId, 1L);
    }

    @Test
    public void shouldHandleEmptyLog() throws Exception {
        CommittedTransactionRepresentation[] readTransactions = this.readAllFromReversedCursor();
        Assert.assertEquals((long)0L, (long)readTransactions.length);
    }

    @Test
    public void shouldDetectAndPreventChannelReadingMultipleLogVersions() throws Exception {
        this.writeTransactions(1, 1, 1);
        this.logFile.rotate();
        this.writeTransactions(1, 1, 1);
        try (ReadAheadLogChannel channel = (ReadAheadLogChannel)this.logFile.getReader(LogPosition.start((long)0L));){
            new ReversedSingleFileTransactionCursor(channel, (LogEntryReader)new VersionAwareLogEntryReader(), false, (ReversedTransactionCursorMonitor)this.monitor);
            Assert.fail((String)"Should've failed");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"multiple log versions"));
        }
    }

    @Test
    public void readCorruptedTransactionLog() throws IOException {
        int readableTransactions = 10;
        this.writeTransactions(readableTransactions, 1, 1);
        this.appendCorruptedTransaction();
        this.writeTransactions(readableTransactions, 1, 1);
        CommittedTransactionRepresentation[] committedTransactionRepresentations = this.readAllFromReversedCursor();
        this.assertTransactionRange(committedTransactionRepresentations, (long)readableTransactions + 1L, 1L);
    }

    @Test
    public void failToReadCorruptedTransactionLogWhenConfigured() throws IOException {
        int readableTransactions = 10;
        this.writeTransactions(readableTransactions, 1, 1);
        this.appendCorruptedTransaction();
        this.writeTransactions(readableTransactions, 1, 1);
        this.expectedException.expect(UnsupportedLogVersionException.class);
        this.readAllFromReversedCursorFailOnCorrupted();
    }

    private CommittedTransactionRepresentation[] readAllFromReversedCursor() throws IOException {
        try (ReversedSingleFileTransactionCursor cursor = this.txCursor(false);){
            CommittedTransactionRepresentation[] committedTransactionRepresentationArray = GivenTransactionCursor.exhaust((TransactionCursor)cursor);
            return committedTransactionRepresentationArray;
        }
    }

    private CommittedTransactionRepresentation[] readAllFromReversedCursorFailOnCorrupted() throws IOException {
        try (ReversedSingleFileTransactionCursor cursor = this.txCursor(true);){
            CommittedTransactionRepresentation[] committedTransactionRepresentationArray = GivenTransactionCursor.exhaust((TransactionCursor)cursor);
            return committedTransactionRepresentationArray;
        }
    }

    private void assertTransactionRange(CommittedTransactionRepresentation[] readTransactions, long highTxId, long lowTxId) {
        long expectedTxId = highTxId;
        for (CommittedTransactionRepresentation tx : readTransactions) {
            Assert.assertEquals((long)expectedTxId, (long)tx.getCommitEntry().getTxId());
            --expectedTxId;
        }
        Assert.assertEquals((long)expectedTxId, (long)lowTxId);
    }

    private ReversedSingleFileTransactionCursor txCursor(boolean failOnCorruptedLogFiles) throws IOException {
        ReadAheadLogChannel fileReader = (ReadAheadLogChannel)this.logFile.getReader(LogPosition.start((long)0L), LogVersionBridge.NO_MORE_CHANNELS);
        try {
            return new ReversedSingleFileTransactionCursor(fileReader, (LogEntryReader)new VersionAwareLogEntryReader(), failOnCorruptedLogFiles, (ReversedTransactionCursorMonitor)this.monitor);
        }
        catch (UnsupportedLogVersionException e) {
            fileReader.close();
            throw e;
        }
    }

    private void writeTransactions(int transactionCount, int minTransactionSize, int maxTransactionSize) throws IOException {
        FlushablePositionAwareChannel channel = this.logFile.getWriter();
        TransactionLogWriter writer = new TransactionLogWriter(new LogEntryWriter((WritableChannel)channel));
        for (int i = 0; i < transactionCount; ++i) {
            writer.append(this.tx(this.random.intBetween(minTransactionSize, maxTransactionSize)), ++this.txId);
        }
        channel.prepareForFlush().flush();
    }

    private void appendCorruptedTransaction() throws IOException {
        FlushablePositionAwareChannel channel = this.logFile.getWriter();
        TransactionLogWriter writer = new TransactionLogWriter((LogEntryWriter)new CorruptedLogEntryWriter((FlushableChannel)channel));
        writer.append(this.tx(this.random.intBetween(100, 1000)), ++this.txId);
    }

    private TransactionRepresentation tx(int size) {
        ArrayList<Command.NodeCommand> commands = new ArrayList<Command.NodeCommand>();
        for (int i = 0; i < size; ++i) {
            commands.add(new Command.NodeCommand(new NodeRecord((long)i), new NodeRecord((long)i).initialize(true, (long)i, false, (long)i, Record.NO_LABELS_FIELD.longValue())));
        }
        PhysicalTransactionRepresentation tx = new PhysicalTransactionRepresentation(commands);
        tx.setHeader(new byte[0], 0, 0, 0L, 0L, 0L, 0);
        return tx;
    }

    private static class CorruptedLogEntryWriter
    extends LogEntryWriter {
        CorruptedLogEntryWriter(FlushableChannel channel) {
            super((WritableChannel)channel);
        }

        public void writeStartEntry(int masterId, int authorId, long timeWritten, long latestCommittedTxWhenStarted, byte[] additionalHeaderData) throws IOException {
            CorruptedLogEntryWriter.writeLogEntryHeader((byte)1, (WritableChannel)this.channel);
        }
    }
}

