/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.util.ArrayQueueOutOfOrderSequence;
import org.neo4j.kernel.impl.util.OutOfOrderSequence;

public class SimpleTransactionIdStore
implements TransactionIdStore {
    private final AtomicLong committingTransactionId = new AtomicLong();
    private final OutOfOrderSequence closedTransactionId = new ArrayQueueOutOfOrderSequence(-1L, 100, new long[1]);
    private final AtomicReference<TransactionId> committedTransactionId = new AtomicReference<TransactionId>(new TransactionId(1L, 0L, 0L));
    private final long previouslyCommittedTxId;
    private final long initialTransactionChecksum;
    private final long previouslyCommittedTxCommitTimestamp;

    public SimpleTransactionIdStore() {
        this(1L, 0L, 0L, 0L, 16L);
    }

    public SimpleTransactionIdStore(long previouslyCommittedTxId, long checksum, long previouslyCommittedTxCommitTimestamp, long previouslyCommittedTxLogVersion, long previouslyCommittedTxLogByteOffset) {
        assert (previouslyCommittedTxId >= 1L) : "cannot start from a tx id less than BASE_TX_ID";
        this.setLastCommittedAndClosedTransactionId(previouslyCommittedTxId, checksum, previouslyCommittedTxCommitTimestamp, previouslyCommittedTxLogByteOffset, previouslyCommittedTxLogVersion);
        this.previouslyCommittedTxId = previouslyCommittedTxId;
        this.initialTransactionChecksum = checksum;
        this.previouslyCommittedTxCommitTimestamp = previouslyCommittedTxCommitTimestamp;
    }

    public long nextCommittingTransactionId() {
        return this.committingTransactionId.incrementAndGet();
    }

    public long committingTransactionId() {
        return this.committingTransactionId.get();
    }

    public synchronized void transactionCommitted(long transactionId, long checksum, long commitTimestamp) {
        TransactionId current = this.committedTransactionId.get();
        if (current == null || transactionId > current.transactionId()) {
            this.committedTransactionId.set(new TransactionId(transactionId, checksum, commitTimestamp));
        }
    }

    public long getLastCommittedTransactionId() {
        return this.committedTransactionId.get().transactionId();
    }

    public TransactionId getLastCommittedTransaction() {
        return this.committedTransactionId.get();
    }

    public TransactionId getUpgradeTransaction() {
        return new TransactionId(this.previouslyCommittedTxId, this.initialTransactionChecksum, this.previouslyCommittedTxCommitTimestamp);
    }

    public long getLastClosedTransactionId() {
        return this.closedTransactionId.getHighestGapFreeNumber();
    }

    public void awaitClosedTransactionId(long txId, long timeoutMillis) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public long[] getLastClosedTransaction() {
        return this.closedTransactionId.get();
    }

    public void setLastCommittedAndClosedTransactionId(long transactionId, long checksum, long commitTimestamp, long byteOffset, long logVersion) {
        this.committingTransactionId.set(transactionId);
        this.committedTransactionId.set(new TransactionId(transactionId, checksum, commitTimestamp));
        this.closedTransactionId.set(transactionId, new long[]{logVersion, byteOffset});
    }

    public void transactionClosed(long transactionId, long logVersion, long byteOffset) {
        this.closedTransactionId.offer(transactionId, new long[]{logVersion, byteOffset});
    }

    public void flush() {
    }
}

