/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.NoSuchTransactionException;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogicalTransactionStore;

public class LogVersionLocatorTest {
    private final long firstTxIdInLog = 3L;
    private final long lastTxIdInLog = 67L;

    @Test
    public void shouldFindLogPosition() throws NoSuchTransactionException {
        long txId = 42L;
        PhysicalLogicalTransactionStore.LogVersionLocator locator = new PhysicalLogicalTransactionStore.LogVersionLocator(42L);
        LogPosition position = new LogPosition(1L, 128L);
        boolean result = locator.visit(position, 3L, 67L);
        Assert.assertFalse((boolean)result);
        Assert.assertEquals((Object)position, (Object)locator.getLogPosition());
    }

    @Test
    public void shouldNotFindLogPosition() {
        long txId = 1L;
        PhysicalLogicalTransactionStore.LogVersionLocator locator = new PhysicalLogicalTransactionStore.LogVersionLocator(1L);
        LogPosition position = new LogPosition(1L, 128L);
        boolean result = locator.visit(position, 3L, 67L);
        Assert.assertTrue((boolean)result);
        try {
            locator.getLogPosition();
            Assert.fail((String)"should have thrown");
        }
        catch (NoSuchTransactionException e) {
            Assert.assertEquals((Object)"Unable to find transaction 1 in any of my logical logs: Couldn't find any log containing 1", (Object)e.getMessage());
        }
    }

    @Test
    public void shouldAlwaysThrowIfVisitIsNotCalled() {
        long txId = 1L;
        PhysicalLogicalTransactionStore.LogVersionLocator locator = new PhysicalLogicalTransactionStore.LogVersionLocator(1L);
        try {
            locator.getLogPosition();
            Assert.fail((String)"should have thrown");
        }
        catch (NoSuchTransactionException e) {
            Assert.assertEquals((Object)"Unable to find transaction 1 in any of my logical logs: Couldn't find any log containing 1", (Object)e.getMessage());
        }
    }
}

