/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.participant;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.format.StoreVersion;
import org.neo4j.kernel.impl.storemigration.participant.CountsMigrator;
import org.neo4j.kernel.impl.util.monitoring.ProgressReporter;
import org.neo4j.kernel.impl.util.monitoring.SilentProgressReporter;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class CountsMigratorTest {
    private final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private final TestDirectory directory = TestDirectory.testDirectory((FileSystemAbstraction)this.fs);
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.fs).around((TestRule)this.directory);

    @Test
    public void shouldNotAccidentallyDeleteStoreFilesIfNoMigrationWasRequired() throws IOException {
        CountsMigrator migrator = new CountsMigrator((FileSystemAbstraction)this.fs, null, Config.defaults());
        DatabaseLayout sourceLayout = this.directory.databaseLayout();
        File countsStoreFileA = sourceLayout.countStoreA();
        File countsStoreFileB = sourceLayout.countStoreB();
        this.fs.create(countsStoreFileA);
        this.fs.create(countsStoreFileB);
        DatabaseLayout migrationLayout = this.directory.databaseLayout("migration");
        String versionToMigrateFrom = StoreVersion.STANDARD_V3_2.versionString();
        String versionToMigrateTo = StoreVersion.STANDARD_V3_4.versionString();
        migrator.migrate(sourceLayout, migrationLayout, (ProgressReporter)SilentProgressReporter.INSTANCE, versionToMigrateFrom, versionToMigrateTo);
        Assert.assertEquals((String)"Invalid test assumption: There should not have been migration for those versions", (long)0L, (long)migrationLayout.listDatabaseFiles((dir, name) -> true).length);
        migrator.moveMigratedFiles(migrationLayout, sourceLayout, versionToMigrateFrom, versionToMigrateTo);
        Assert.assertTrue((boolean)this.fs.fileExists(countsStoreFileA));
        Assert.assertTrue((boolean)this.fs.fileExists(countsStoreFileB));
    }
}

