/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.store.kvstore.RotationTimerFactory;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;
import org.neo4j.time.SystemNanoClock;

public class RotationTimerFactoryTest {
    @Test
    public void testTimer() {
        FakeClock fakeClock = Clocks.fakeClock((long)10000L, (TimeUnit)TimeUnit.MILLISECONDS);
        RotationTimerFactory timerFactory = new RotationTimerFactory((SystemNanoClock)fakeClock, 1000L);
        RotationTimerFactory.RotationTimer timer = timerFactory.createTimer();
        RotationTimerFactory.RotationTimer anotherTimer = timerFactory.createTimer();
        Assert.assertFalse((boolean)timer.isTimedOut());
        Assert.assertEquals((long)0L, (long)timer.getElapsedTimeMillis());
        Assert.assertNotSame((String)"Factory should construct different timers", (Object)timer, (Object)anotherTimer);
        fakeClock = Clocks.fakeClock();
        RotationTimerFactory fakeTimerFactory = new RotationTimerFactory((SystemNanoClock)fakeClock, 1000L);
        RotationTimerFactory.RotationTimer fakeTimer = fakeTimerFactory.createTimer();
        fakeClock.forward(1001L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)fakeTimer.isTimedOut());
        Assert.assertEquals((long)1001L, (long)fakeTimer.getElapsedTimeMillis());
    }
}

