/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.io.File;
import java.io.IOException;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;
import org.mockito.Mockito;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.kvstore.KeyValueStoreFile;
import org.neo4j.kernel.impl.store.kvstore.WritableBuffer;

public class KeyValueStoreFileTest {
    public ExpectedException exception = ExpectedException.none();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)Timeout.seconds((long)1000L)).around((TestRule)this.exception);

    @Test
    public void shouldFailAfterEnoughAttempts() throws IOException {
        WritableBuffer buffer = (WritableBuffer)Mockito.mock(WritableBuffer.class);
        PageCursor cursor = (PageCursor)Mockito.mock(PageCursor.class);
        Mockito.when((Object)cursor.shouldRetry()).thenReturn((Object)true);
        Mockito.when((Object)cursor.getCurrentFile()).thenReturn((Object)new File("foo/bar.a"));
        this.exception.expect(UnderlyingStorageException.class);
        KeyValueStoreFile.readKeyValuePair((PageCursor)cursor, (int)42, (WritableBuffer)buffer, (WritableBuffer)buffer);
    }
}

