/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.store.kvstore.BigEndianByteArrayBuffer;
import org.neo4j.kernel.impl.store.kvstore.DataProvider;
import org.neo4j.kernel.impl.store.kvstore.EntryVisitor;
import org.neo4j.kernel.impl.store.kvstore.KeyValueMerger;
import org.neo4j.kernel.impl.store.kvstore.WritableBuffer;

public class KeyValueMergerTest {
    @Test
    public void shouldMergeEmptyProviders() throws Exception {
        KeyValueMerger merger = new KeyValueMerger(KeyValueMergerTest.provider(new Pair[0]), KeyValueMergerTest.provider(new Pair[0]), 4, 4);
        List<Integer> data = KeyValueMergerTest.extract((EntryVisitor<WritableBuffer>)merger);
        Assert.assertEquals(Arrays.asList(new Integer[0]), data);
    }

    @Test
    public void shouldProvideUpdatesWhenNoDataProvided() throws Exception {
        KeyValueMerger merger = new KeyValueMerger(KeyValueMergerTest.provider(new Pair[0]), KeyValueMergerTest.provider(Pair.pair(14, 1), Pair.pair(19, 2), Pair.pair(128, 3)), 4, 4);
        List<Integer> data = KeyValueMergerTest.extract((EntryVisitor<WritableBuffer>)merger);
        Assert.assertEquals(Arrays.asList(14, 1, 19, 2, 128, 3), data);
    }

    @Test
    public void shouldProvideUpdatesWhenNoChangesProvided() throws Exception {
        KeyValueMerger merger = new KeyValueMerger(KeyValueMergerTest.provider(Pair.pair(14, 1), Pair.pair(19, 2), Pair.pair(128, 3)), KeyValueMergerTest.provider(new Pair[0]), 4, 4);
        List<Integer> data = KeyValueMergerTest.extract((EntryVisitor<WritableBuffer>)merger);
        Assert.assertEquals(Arrays.asList(14, 1, 19, 2, 128, 3), data);
    }

    @Test
    public void shouldMergeDataStreams() throws Exception {
        KeyValueMerger merger = new KeyValueMerger(KeyValueMergerTest.provider(Pair.pair(1, 1), Pair.pair(3, 1), Pair.pair(5, 1)), KeyValueMergerTest.provider(Pair.pair(2, 2), Pair.pair(4, 2), Pair.pair(6, 2)), 4, 4);
        List<Integer> data = KeyValueMergerTest.extract((EntryVisitor<WritableBuffer>)merger);
        Assert.assertEquals(Arrays.asList(1, 1, 2, 2, 3, 1, 4, 2, 5, 1, 6, 2), data);
    }

    @Test
    public void shouldReplaceValuesOnEqualKey() throws Exception {
        KeyValueMerger merger = new KeyValueMerger(KeyValueMergerTest.provider(Pair.pair(1, 1), Pair.pair(3, 1), Pair.pair(5, 1)), KeyValueMergerTest.provider(Pair.pair(2, 2), Pair.pair(3, 2), Pair.pair(6, 2)), 4, 4);
        List<Integer> data = KeyValueMergerTest.extract((EntryVisitor<WritableBuffer>)merger);
        Assert.assertEquals(Arrays.asList(1, 1, 2, 2, 3, 2, 5, 1, 6, 2), data);
    }

    private static List<Integer> extract(EntryVisitor<WritableBuffer> producer) throws IOException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        BigEndianByteArrayBuffer key = new BigEndianByteArrayBuffer(4);
        BigEndianByteArrayBuffer value = new BigEndianByteArrayBuffer(4);
        while (producer.visit((Object)key, (Object)value)) {
            result.add(key.getInt(0));
            result.add(value.getInt(0));
        }
        return result;
    }

    static DataProvider provider(final Pair ... data) {
        return new DataProvider(){
            int i;

            public boolean visit(WritableBuffer key, WritableBuffer value) {
                if (this.i < data.length) {
                    data[this.i++].visit(key, value);
                    return true;
                }
                return false;
            }

            public void close() {
            }
        };
    }

    static class Pair {
        final int key;
        int value;

        static Pair pair(int key, int value) {
            return new Pair(key, value);
        }

        Pair(int key, int value) {
            this.key = key;
            this.value = value;
        }

        void visit(WritableBuffer key, WritableBuffer value) {
            key.putInt(0, this.key);
            value.putInt(0, this.value);
        }
    }
}

