/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format;

import java.util.Arrays;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.kernel.impl.store.IntStoreHeader;
import org.neo4j.kernel.impl.store.NoStoreHeader;
import org.neo4j.kernel.impl.store.StoreHeader;
import org.neo4j.kernel.impl.store.format.FullyCoveringRecordKeys;
import org.neo4j.kernel.impl.store.format.LimitedRecordGenerators;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.RecordGenerators;
import org.neo4j.kernel.impl.store.format.RecordKeys;
import org.neo4j.kernel.impl.store.id.BatchingIdSequence;
import org.neo4j.kernel.impl.store.id.IdSequence;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;

@ExtendWith(value={RandomExtension.class})
public abstract class AbstractRecordCloningTest {
    @Inject
    private RandomRule random;
    private RecordKeys keys;
    private IdSequence idSequence;
    private RecordGenerators.Generator<NodeRecord> nodes;
    private RecordGenerators.Generator<DynamicRecord> dynamics;
    private RecordGenerators.Generator<LabelTokenRecord> labelTokens;
    private RecordGenerators.Generator<PropertyRecord> properties;
    private RecordGenerators.Generator<PropertyKeyTokenRecord> propertyKeyTokens;
    private RecordGenerators.Generator<RelationshipRecord> relationships;
    private RecordGenerators.Generator<RelationshipGroupRecord> relationshipGroups;
    private RecordGenerators.Generator<RelationshipTypeTokenRecord> relationshipTypeTokens;
    private RecordFormat<NodeRecord> nodeFormat;
    private RecordFormat<DynamicRecord> dynamicFormat;
    private RecordFormat<LabelTokenRecord> labelTokenFormat;
    private RecordFormat<PropertyRecord> propertyFormat;
    private RecordFormat<PropertyKeyTokenRecord> propertyKeyTokenFormat;
    private RecordFormat<RelationshipRecord> relationshipFormat;
    private RecordFormat<RelationshipGroupRecord> relationshipGroupFormat;
    private RecordFormat<RelationshipTypeTokenRecord> relationshipTypeTokenFormat;
    private int nodeRecordSize;
    private int dynamicRecordSize;
    private int labelTokenRecordSize;
    private int propertyRecordSize;
    private int propertyKeyTokenRecordSize;
    private int relationshipRecordSize;
    private int relationshipGroupRecordSize;
    private int relationshipTypeTokenRecordSize;

    protected abstract RecordFormats formats();

    protected abstract int entityBits();

    protected abstract int propertyBits();

    @BeforeEach
    private void setUp() {
        RecordFormats formats = this.formats();
        LimitedRecordGenerators generators = new LimitedRecordGenerators(this.random.randomValues(), this.entityBits(), this.propertyBits(), 40, 16, -1L);
        this.keys = FullyCoveringRecordKeys.INSTANCE;
        this.idSequence = new BatchingIdSequence(1L);
        this.nodes = generators.node();
        this.dynamics = generators.dynamic();
        this.labelTokens = generators.labelToken();
        this.properties = generators.property();
        this.propertyKeyTokens = generators.propertyKeyToken();
        this.relationships = generators.relationship();
        this.relationshipGroups = generators.relationshipGroup();
        this.relationshipTypeTokens = generators.relationshipTypeToken();
        this.dynamicFormat = formats.dynamic();
        this.labelTokenFormat = formats.labelToken();
        this.nodeFormat = formats.node();
        this.propertyFormat = formats.property();
        this.propertyKeyTokenFormat = formats.propertyKeyToken();
        this.relationshipFormat = formats.relationship();
        this.relationshipGroupFormat = formats.relationshipGroup();
        this.relationshipTypeTokenFormat = formats.relationshipTypeToken();
        this.dynamicRecordSize = this.dynamicFormat.getRecordSize((StoreHeader)new IntStoreHeader(128));
        this.labelTokenRecordSize = this.labelTokenFormat.getRecordSize((StoreHeader)NoStoreHeader.NO_STORE_HEADER);
        this.nodeRecordSize = this.nodeFormat.getRecordSize((StoreHeader)NoStoreHeader.NO_STORE_HEADER);
        this.propertyRecordSize = this.propertyFormat.getRecordSize((StoreHeader)NoStoreHeader.NO_STORE_HEADER);
        this.propertyKeyTokenRecordSize = this.propertyKeyTokenFormat.getRecordSize((StoreHeader)NoStoreHeader.NO_STORE_HEADER);
        this.relationshipRecordSize = this.relationshipFormat.getRecordSize((StoreHeader)NoStoreHeader.NO_STORE_HEADER);
        this.relationshipGroupRecordSize = this.relationshipGroupFormat.getRecordSize((StoreHeader)new IntStoreHeader(50));
        this.relationshipTypeTokenRecordSize = this.relationshipTypeTokenFormat.getRecordSize((StoreHeader)NoStoreHeader.NO_STORE_HEADER);
    }

    @RepeatedTest(value=1000)
    void plainDynamicClone() {
        DynamicRecord dynamicRecord = this.getDynamicRecord();
        this.keys.dynamic().assertRecordsEquals(dynamicRecord, dynamicRecord.clone());
    }

    @RepeatedTest(value=1000)
    void preparedDynamicClone() {
        DynamicRecord dynamicRecord = this.getDynamicRecord();
        this.dynamicFormat.prepare((AbstractBaseRecord)dynamicRecord, this.dynamicRecordSize, this.idSequence);
        this.keys.dynamic().assertRecordsEquals(dynamicRecord, dynamicRecord.clone());
    }

    @RepeatedTest(value=1000)
    void plainLabelTokenClone() {
        LabelTokenRecord labelTokenRecord = this.getLabelTokenRecord();
        this.keys.labelToken().assertRecordsEquals(labelTokenRecord, labelTokenRecord.clone());
    }

    @RepeatedTest(value=1000)
    void preparedLabelTokenClone() {
        LabelTokenRecord labelTokenRecord = this.getLabelTokenRecord();
        this.labelTokenFormat.prepare((AbstractBaseRecord)labelTokenRecord, this.labelTokenRecordSize, this.idSequence);
        this.keys.labelToken().assertRecordsEquals(labelTokenRecord, labelTokenRecord.clone());
    }

    @RepeatedTest(value=1000)
    void plainNodeClone() {
        NodeRecord nodeRecord = this.getNodeRecord();
        this.keys.node().assertRecordsEquals(nodeRecord, nodeRecord.clone());
    }

    @RepeatedTest(value=1000)
    void preparedNodeClone() {
        NodeRecord nodeRecord = this.getNodeRecord();
        this.nodeFormat.prepare((AbstractBaseRecord)nodeRecord, this.nodeRecordSize, this.idSequence);
        this.keys.node().assertRecordsEquals(nodeRecord, nodeRecord.clone());
    }

    @RepeatedTest(value=1000)
    void plainNodeWithDynamicLabelsClone() {
        NodeRecord nodeRecord = this.getNodeRecord();
        nodeRecord.setLabelField(12L, Arrays.asList(this.getDynamicRecord(), this.getDynamicRecord()));
        this.keys.node().assertRecordsEquals(nodeRecord, nodeRecord.clone());
    }

    @RepeatedTest(value=1000)
    void preparedNodeWithDynamicLabelsClone() {
        NodeRecord nodeRecord = this.getNodeRecord();
        nodeRecord.setLabelField(12L, Arrays.asList(this.getDynamicRecord(), this.getDynamicRecord()));
        this.nodeFormat.prepare((AbstractBaseRecord)nodeRecord, this.nodeRecordSize, this.idSequence);
        this.keys.node().assertRecordsEquals(nodeRecord, nodeRecord.clone());
    }

    @RepeatedTest(value=1000)
    void plainPropertyClone() {
        PropertyRecord propertyRecord = this.getPropertyRecord();
        this.keys.property().assertRecordsEquals(propertyRecord, propertyRecord.clone());
    }

    @RepeatedTest(value=1000)
    void preparedPropertyClone() {
        PropertyRecord propertyRecord = this.getPropertyRecord();
        this.propertyFormat.prepare((AbstractBaseRecord)propertyRecord, this.propertyRecordSize, this.idSequence);
        this.keys.property().assertRecordsEquals(propertyRecord, propertyRecord.clone());
    }

    @RepeatedTest(value=1000)
    void plainPropertyKeyTokenClone() {
        PropertyKeyTokenRecord propertyKeyTokenRecord = this.getPropertyKeyTokenRecord();
        this.keys.propertyKeyToken().assertRecordsEquals(propertyKeyTokenRecord, propertyKeyTokenRecord.clone());
    }

    @RepeatedTest(value=1000)
    void preparedPropertyKeyTokenClone() {
        PropertyKeyTokenRecord propertyKeyTokenRecord = this.getPropertyKeyTokenRecord();
        this.propertyKeyTokenFormat.prepare((AbstractBaseRecord)propertyKeyTokenRecord, this.propertyKeyTokenRecordSize, this.idSequence);
        this.keys.propertyKeyToken().assertRecordsEquals(propertyKeyTokenRecord, propertyKeyTokenRecord.clone());
    }

    @RepeatedTest(value=1000)
    void plainRelationshipClone() {
        RelationshipRecord relationshipRecord = this.getRelationshipRecord();
        this.keys.relationship().assertRecordsEquals(relationshipRecord, relationshipRecord.clone());
    }

    @RepeatedTest(value=1000)
    void preparedRelationshipClone() {
        RelationshipRecord relationshipRecord = this.getRelationshipRecord();
        this.relationshipFormat.prepare((AbstractBaseRecord)relationshipRecord, this.relationshipRecordSize, this.idSequence);
        this.keys.relationship().assertRecordsEquals(relationshipRecord, relationshipRecord.clone());
    }

    @RepeatedTest(value=1000)
    void plainRelationshipGroupClone() {
        RelationshipGroupRecord relationshipGroupRecord = this.getRelationshipGroupRecord();
        this.keys.relationshipGroup().assertRecordsEquals(relationshipGroupRecord, relationshipGroupRecord.clone());
    }

    @RepeatedTest(value=1000)
    void preparedRelationshipGroupClone() {
        RelationshipGroupRecord relationshipGroupRecord = this.getRelationshipGroupRecord();
        this.relationshipGroupFormat.prepare((AbstractBaseRecord)relationshipGroupRecord, this.relationshipGroupRecordSize, this.idSequence);
        this.keys.relationshipGroup().assertRecordsEquals(relationshipGroupRecord, relationshipGroupRecord.clone());
    }

    @RepeatedTest(value=1000)
    void plainRelationshipTypeTokenClone() {
        RelationshipTypeTokenRecord relationshipTypeTokenRecord = this.getRelationshipTypeTokenRecord();
        this.keys.relationshipTypeToken().assertRecordsEquals(relationshipTypeTokenRecord, relationshipTypeTokenRecord.clone());
    }

    @RepeatedTest(value=1000)
    void preparedRelationshipTypeTokenClone() {
        RelationshipTypeTokenRecord relationshipTypeTokenRecord = this.getRelationshipTypeTokenRecord();
        this.relationshipTypeTokenFormat.prepare((AbstractBaseRecord)relationshipTypeTokenRecord, this.relationshipTypeTokenRecordSize, this.idSequence);
        this.keys.relationshipTypeToken().assertRecordsEquals(relationshipTypeTokenRecord, relationshipTypeTokenRecord.clone());
    }

    private DynamicRecord getDynamicRecord() {
        return this.dynamics.get(this.dynamicRecordSize, this.dynamicFormat, this.random.nextLong(1L, this.dynamicFormat.getMaxId()));
    }

    private LabelTokenRecord getLabelTokenRecord() {
        return this.labelTokens.get(this.labelTokenRecordSize, this.labelTokenFormat, this.random.nextLong(1L, this.labelTokenFormat.getMaxId()));
    }

    private NodeRecord getNodeRecord() {
        return this.nodes.get(this.nodeRecordSize, this.nodeFormat, this.random.nextLong(1L, this.nodeFormat.getMaxId()));
    }

    private PropertyRecord getPropertyRecord() {
        return this.properties.get(this.propertyRecordSize, this.propertyFormat, this.random.nextLong(1L, this.propertyFormat.getMaxId()));
    }

    private PropertyKeyTokenRecord getPropertyKeyTokenRecord() {
        return this.propertyKeyTokens.get(this.propertyKeyTokenRecordSize, this.propertyKeyTokenFormat, this.random.nextLong(1L, this.propertyKeyTokenFormat.getMaxId()));
    }

    private RelationshipRecord getRelationshipRecord() {
        return this.relationships.get(this.relationshipRecordSize, this.relationshipFormat, this.random.nextLong(1L, this.relationshipFormat.getMaxId()));
    }

    private RelationshipGroupRecord getRelationshipGroupRecord() {
        return this.relationshipGroups.get(this.relationshipGroupRecordSize, this.relationshipGroupFormat, this.random.nextLong(1L, this.relationshipGroupFormat.getMaxId()));
    }

    private RelationshipTypeTokenRecord getRelationshipTypeTokenRecord() {
        return this.relationshipTypeTokens.get(this.relationshipTypeTokenRecordSize, this.relationshipTypeTokenFormat, this.random.nextLong(1L, this.relationshipTypeTokenFormat.getMaxId()));
    }
}

