/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.kernel.impl.store.StoreType;

public class StoreTypeTest {
    @Test
    public void storeTypeOfValidStoreFile() {
        StoreType matchedType = (StoreType)StoreType.typeOf((DatabaseFile)DatabaseFile.NODE_STORE).orElseThrow(() -> new IllegalStateException("Store type not found"));
        Assert.assertEquals((Object)StoreType.NODE, (Object)matchedType);
    }

    @Test
    public void storeTypeOfMetaDataStoreFile() {
        StoreType matchedType = (StoreType)StoreType.typeOf((DatabaseFile)DatabaseFile.METADATA_STORE).orElseThrow(() -> new IllegalStateException("Store type not found"));
        Assert.assertEquals((Object)StoreType.META_DATA, (Object)matchedType);
    }

    @Test
    public void storeTypeofSomeInvalidFile() {
        Assert.assertThat((Object)StoreType.typeOf((DatabaseFile)DatabaseFile.LABEL_SCAN_STORE), (Matcher)Matchers.is(Optional.empty()));
    }
}

