/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.impl.store.PropertyValueRecordSizeCalculator;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class PropertyValueRecordSizeCalculatorTest {
    private static final int PROPERTY_RECORD_SIZE = 41;
    private static final int DYNAMIC_RECORD_SIZE = 120;
    @Rule
    public final RandomRule random = new RandomRule();

    @Test
    public void shouldIncludePropertyRecordSize() {
        PropertyValueRecordSizeCalculator calculator = this.newCalculator();
        int size = calculator.applyAsInt(new Value[]{Values.of((Object)10)});
        Assert.assertEquals((long)41L, (long)size);
    }

    @Test
    public void shouldIncludeDynamicRecordSizes() {
        PropertyValueRecordSizeCalculator calculator = this.newCalculator();
        int size = calculator.applyAsInt(new Value[]{Values.of((Object)this.string(80)), Values.of((Object)new String[]{this.string(150)})});
        Assert.assertEquals((long)401L, (long)size);
    }

    @Test
    public void shouldSpanMultiplePropertyRecords() {
        PropertyValueRecordSizeCalculator calculator = this.newCalculator();
        int size = calculator.applyAsInt(new Value[]{Values.of((Object)10), Values.of((Object)"test"), Values.of((Object)5), Values.of((Object)this.string(80)), Values.of((Object)"a bit longer short string"), Values.of((Object)1234567890123456789L), Values.of((Object)5), Values.of((Object)"value")});
        Assert.assertEquals((long)243L, (long)size);
    }

    private String string(int length) {
        return this.random.nextAlphaNumericString(length, length);
    }

    private PropertyValueRecordSizeCalculator newCalculator() {
        return new PropertyValueRecordSizeCalculator(41, 120, 110, 120, 110);
    }
}

